package com.paypal.hybris.facade.facades.impl;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.user.UserService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.verify;

@UnitTest
public class DefaultPayPalSetUpPasswordFacadeTest {

    private static final String PASSWORD = "12341234";
    private static final String PASSWORD_ENCODING = "SHA512";
    private static final String UID = "UID";

    @Mock
    private UserService userService;
    @Mock
    private ModelService modelService;
    @Mock
    private CustomerModel customerModel;

    @InjectMocks
    private DefaultPayPalSetUpPasswordFacade unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        when(userService.getCurrentUser()).thenReturn(customerModel);
        when(userService.getUserForUID(UID)).thenReturn(customerModel);
        when(customerModel.isPasswordForSingleAuthenticationActive()).thenReturn(false);
    }

    @Test
    public void shouldSetUpPassword() {
        when(customerModel.getPasswordEncoding()).thenReturn(PASSWORD_ENCODING);
        doNothing().when(userService).setPassword(customerModel, PASSWORD, PASSWORD_ENCODING);
        doNothing().when(modelService).save(customerModel);

        unit.setUpPassword(PASSWORD);

        verify(userService).getCurrentUser();
        verify(customerModel).getPasswordEncoding();
        verify(userService).setPassword(customerModel, PASSWORD, PASSWORD_ENCODING);
        verify(customerModel).setPasswordForSingleAuthenticationActive(true);
        verify(modelService).save(customerModel);
    }

    @Test
    public void isSetUpPasswordForm() {
        boolean result = unit.isSetUpPasswordForm();

        assertTrue(result);
        verify(userService).getCurrentUser();
        verify(customerModel).isPasswordForSingleAuthenticationActive();
    }

    @Test
    public void isSetUpPasswordFormParameterUserId() {
        boolean result = unit.isSetUpPasswordForm(UID);

        assertTrue(result);
        verify(userService).getUserForUID(UID);
        verify(customerModel).isPasswordForSingleAuthenticationActive();
    }

    @Test
    public void isSetUpPasswordFormWhenSingleAuthenticationInactive() {
        when(customerModel.isPasswordForSingleAuthenticationActive()).thenReturn(true);
        boolean result = unit.isSetUpPasswordForm();

        assertFalse(result);
        verify(userService).getCurrentUser();
        verify(customerModel).isPasswordForSingleAuthenticationActive();
    }

    @Test
    public void isSetUpPasswordFormParameterUserIdWhenSingleAuthenticationInactive() {
        when(customerModel.isPasswordForSingleAuthenticationActive()).thenReturn(true);
        boolean result = unit.isSetUpPasswordForm(UID);

        assertFalse(result);
        verify(userService).getUserForUID(UID);
        verify(customerModel).isPasswordForSingleAuthenticationActive();
    }

    @Test
    public void shouldSetPasswordForSingleAuthenticationActiveToCustomer() {
        doNothing().when(modelService).save(customerModel);

        unit.setPasswordForSingleAuthenticationActiveToCustomer(UID, true);

        verify(userService).getUserForUID(UID);
        verify(customerModel).setPasswordForSingleAuthenticationActive(true);
        verify(modelService).save(customerModel);
    }
}
