package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.service.PayPalCartService;
import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commerceservices.util.GuidKeyGenerator;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalFraudNetFacadeTest  {

    private static final String CORRELATION_ID = "correlationId";
    private static final String CART_PAGE_TYPE = "cart";
    private static final String BILLING_PAGE_TYPE = "billing";
    private static final String MARK_PAGE_TYPE = "mark";
    private static final String BILLING_FRAUD_NET_ID = "billingFraudNetId";
    private static final String CART_FRAUD_NET_ID = "billingFraudNetId";

    @Mock
    private DefaultPayPalConfigurationService payPalConfigurationService;
    @Mock
    private GuidKeyGenerator guidKeyGenerator;
    @Mock
    private PayPalCartService payPalCartService;

    @InjectMocks
    private DefaultPayPalFraudNetFacade unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetPageIdWhenMarkPageType() {
        when(payPalConfigurationService.getFraudNetId(BILLING_PAGE_TYPE)).thenReturn(BILLING_FRAUD_NET_ID);

        String result = unit.getPageId(MARK_PAGE_TYPE);

        assertEquals(BILLING_FRAUD_NET_ID, result);
    }

    @Test
    public void shouldGetPageIdWhenCartPageType() {
        when(payPalConfigurationService.getFraudNetId(CART_PAGE_TYPE)).thenReturn(CART_FRAUD_NET_ID);

        String result = unit.getPageId(CART_PAGE_TYPE);

        assertEquals(CART_FRAUD_NET_ID, result);
    }

    @Test
    public void shouldGetCorrelationId() {
        when(guidKeyGenerator.generate()).thenReturn("123456-123456-123456-123456-123456-123456");

        assertEquals("123456-123456-123456-123456-1234", unit.getCorrelationId());
    }

    @Test
    public void shouldSaveCorrelationId() {

        doNothing().when(payPalCartService).saveCorrelationId(CORRELATION_ID);

        unit.saveCorrelationId(CORRELATION_ID);

        verify(payPalCartService).saveCorrelationId(CORRELATION_ID);
    }
}
