package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.event.PayPalEmailNotificationEvent;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.event.EventService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static com.paypal.hybris.core.enums.PayPalEmailEvent.LINK;
import static com.paypal.hybris.core.enums.PayPalEmailEvent.UNLINK;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.verify;

@UnitTest
public class DefaultPayPalConnectWithPayPalNotificationFacadeTest {

    private static final String UID = "uid";

    @Mock
    private EventService eventService;

    @InjectMocks
    private DefaultPayPalConnectWithPayPalNotificationFacade unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldSendLinkCustomerEmailNotification() {
        doNothing().when(eventService).publishEvent(new PayPalEmailNotificationEvent(UID, LINK));

        unit.sendLinkCustomerEmailNotification(UID);

        verify(eventService).publishEvent(any());
    }

    @Test
    public void shouldSendUnlinkCustomerEmailNotification() {
        doNothing().when(eventService).publishEvent(new PayPalEmailNotificationEvent(UID, UNLINK));

        unit.sendUnlinkCustomerEmailNotification(UID);

        verify(eventService).publishEvent(any());
    }

}