package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.model.ApplePayConfigurationModel;
import com.paypal.hybris.core.model.ConnectWithPayPalConfigurationModel;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;
import com.paypal.hybris.core.model.LocalPaymentsConfigurationModel;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import com.paypal.hybris.core.model.PayPalGeneralConfigurationModel;
import com.paypal.hybris.core.model.PayPalPluginConfigurationModel;
import com.paypal.hybris.core.model.VenmoConfigurationModel;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.data.ApplePayConfigurationData;
import com.paypal.hybris.data.ConnectWithPayPalConfigurationData;
import com.paypal.hybris.data.HostedFieldsConfigurationData;
import com.paypal.hybris.data.LocalPaymentsConfigurationData;
import com.paypal.hybris.data.PayPalConfigurationData;
import com.paypal.hybris.data.PayPalEssentialConfigurationData;
import com.paypal.hybris.data.PayPalFraudNetConfigurationData;
import com.paypal.hybris.data.PayPalGeneralConfigurationData;
import com.paypal.hybris.data.VenmoConfigurationData;
import com.paypal.hybris.facade.facades.PayPalFraudNetFacade;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Locale;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalConfigurationFacadeTest {

    private static final String CLIENT_ID = "clientId";
    private static final String SDK_JS_URL = "jsUrl";
    private static final String ATTRIBUTION_ID = "attributionId";
    private static final String ENVIRONMENT_TYPE = "envType";
    private static final String CURRENCY = "currency";
    private static final String CORRELATION_ID = "correlationId";
    private static final String LOGIN_PAGE = "LOGIN";
    private static final String PAGE_ID = "pageId";

    @Mock
    private PayPalConfigurationService payPalConfigurationService;
    @Mock
    private PayPalFraudNetFacade payPalFraudNetFacade;
    @Mock
    private PayPalPluginConfigurationModel payPalPluginConfigurationModel;
    @Mock
    private PayPalGeneralConfigurationModel payPalGeneralConfigurationModel;
    @Mock
    private PayPalConfigurationModel payPalConfigurationModel;
    @Mock
    private HostedFieldsConfigurationModel hostedFieldsConfigurationModel;
    @Mock
    private VenmoConfigurationModel venmoConfigurationModel;
    @Mock
    private ConnectWithPayPalConfigurationModel connectWithPayPalConfigurationModel;
    @Mock
    private ApplePayConfigurationModel applePayConfigurationModel;
    @Mock
    private LocalPaymentsConfigurationModel localPaymentsConfigurationModel;

    @Mock
    private Converter<PayPalGeneralConfigurationModel, PayPalGeneralConfigurationData> payPalGeneralConfigurationConverter;
    @Mock
    private Converter<PayPalConfigurationModel, PayPalConfigurationData> payPalConfigurationConverter;
    @Mock
    private Converter<HostedFieldsConfigurationModel, HostedFieldsConfigurationData> hostedFieldsConfigurationConverter;
    @Mock
    private Converter<VenmoConfigurationModel, VenmoConfigurationData> venmoConfigurationConverter;
    @Mock
    private Converter<ConnectWithPayPalConfigurationModel, ConnectWithPayPalConfigurationData> connectWithPayPalConfigurationConverter;
    @Mock
    private Converter<ApplePayConfigurationModel, ApplePayConfigurationData> applePayConfigurationConverter;
    @Mock
    private Converter<LocalPaymentsConfigurationModel, LocalPaymentsConfigurationData> localPaymentsConfigurationConverter;

    @InjectMocks
    private DefaultPayPalConfigurationFacade unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        when(payPalConfigurationService.getPayPalPluginConfiguration()).thenReturn(payPalPluginConfigurationModel);
    }

    @Test
    public void shouldGetPayPalGeneralConfigurationData() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration()).thenReturn(payPalGeneralConfigurationModel);
        when(payPalGeneralConfigurationConverter.convert(payPalGeneralConfigurationModel))
                .thenReturn(new PayPalGeneralConfigurationData());

        unit.getPayPalGeneralConfigurationData();

        verify(payPalConfigurationService).getPayPalPluginConfiguration();
        verify(payPalPluginConfigurationModel).getPayPalGeneralConfiguration();
        verify(payPalGeneralConfigurationConverter).convert(payPalGeneralConfigurationModel);
    }

    @Test
    public void shouldGetPayPalConfigurationData() {
        PayPalConfigurationData payPalConfigurationData = new PayPalConfigurationData();

        when(payPalPluginConfigurationModel.getPayPalConfiguration()).thenReturn(payPalConfigurationModel);
        when(payPalConfigurationConverter.convert(payPalConfigurationModel)).thenReturn(payPalConfigurationData);
        when(payPalConfigurationService.isCommitEnabled()).thenReturn(true);
        when(payPalConfigurationService.isReplenishmentAvailable()).thenReturn(true);
        when(payPalConfigurationService.isSaveOrderFlow()).thenReturn(true);

        PayPalConfigurationData result = unit.getPayPalConfigurationData();

        assertTrue(result.isCommitEnable());
        assertTrue(result.isIsReplenishmentAvailable());
        assertTrue(result.isSaveOrderFlow());

        verify(payPalConfigurationService).isCommitEnabled();
        verify(payPalConfigurationService).isReplenishmentAvailable();
        verify(payPalConfigurationService).isSaveOrderFlow();
        verify(payPalPluginConfigurationModel).getPayPalConfiguration();
        verify(payPalConfigurationConverter).convert(payPalConfigurationModel);
    }

    @Test
    public void shouldGetVenmoConfigurationData() {
        when(payPalPluginConfigurationModel.getVenmoConfiguration()).thenReturn(venmoConfigurationModel);
        when(venmoConfigurationConverter.convert(venmoConfigurationModel))
                .thenReturn(new VenmoConfigurationData());

        unit.getVenmoConfigurationData();

        verify(payPalConfigurationService).getPayPalPluginConfiguration();
        verify(payPalPluginConfigurationModel).getVenmoConfiguration();
        verify(venmoConfigurationConverter).convert(venmoConfigurationModel);
    }

    @Test
    public void shouldGetHostedFieldsConfigurationData() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration()).thenReturn(hostedFieldsConfigurationModel);
        when(hostedFieldsConfigurationConverter.convert(hostedFieldsConfigurationModel))
                .thenReturn(new HostedFieldsConfigurationData());

        unit.getHostedFieldsConfigurationData();

        verify(payPalConfigurationService).getPayPalPluginConfiguration();
        verify(payPalPluginConfigurationModel).getHostedFieldsConfiguration();
        verify(hostedFieldsConfigurationConverter).convert(hostedFieldsConfigurationModel);
    }

    @Test
    public void shouldGetConnectWithPayPalConfigurationData() {
        when(payPalPluginConfigurationModel.getConnectWithPayPalConfiguration())
                .thenReturn(connectWithPayPalConfigurationModel);
        when(connectWithPayPalConfigurationConverter
                .convert(connectWithPayPalConfigurationModel)).thenReturn(new ConnectWithPayPalConfigurationData());

        unit.getConnectWithPayPalConfigurationData();

        verify(payPalConfigurationService).getPayPalPluginConfiguration();
        verify(payPalPluginConfigurationModel).getConnectWithPayPalConfiguration();
        verify(connectWithPayPalConfigurationConverter).convert(connectWithPayPalConfigurationModel);
    }

    @Test
    public void shouldGetApplePayConfigurationData() {
        when(payPalPluginConfigurationModel.getApplePayConfiguration())
                .thenReturn(applePayConfigurationModel);
        when(applePayConfigurationConverter
                .convert(applePayConfigurationModel)).thenReturn(new ApplePayConfigurationData());

        unit.getApplePayConfigurationData();

        verify(payPalConfigurationService).getPayPalPluginConfiguration();
        verify(payPalPluginConfigurationModel).getApplePayConfiguration();
        verify(applePayConfigurationConverter).convert(applePayConfigurationModel);
    }

    @Test
    public void shouldGetLocalPaymentsConfigurationData() {
        when(payPalPluginConfigurationModel.getLocalPaymentsConfiguration())
                .thenReturn(localPaymentsConfigurationModel);
        when(localPaymentsConfigurationConverter
                .convert(localPaymentsConfigurationModel)).thenReturn(new LocalPaymentsConfigurationData());

        unit.getLocalPaymentsConfigurationData();

        verify(payPalConfigurationService).getPayPalPluginConfiguration();
        verify(payPalPluginConfigurationModel).getLocalPaymentsConfiguration();
        verify(localPaymentsConfigurationConverter).convert(localPaymentsConfigurationModel);
    }

    @Test
    public void shouldGetPayPalPluginConfigurationData() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration()).thenReturn(payPalGeneralConfigurationModel);
        when(payPalGeneralConfigurationConverter.convert(payPalGeneralConfigurationModel))
                .thenReturn(new PayPalGeneralConfigurationData());
        when(payPalPluginConfigurationModel.getPayPalConfiguration()).thenReturn(payPalConfigurationModel);
        when(payPalConfigurationConverter.convert(payPalConfigurationModel)).thenReturn(new PayPalConfigurationData());
        when(payPalPluginConfigurationModel.getVenmoConfiguration()).thenReturn(venmoConfigurationModel);
        when(venmoConfigurationConverter.convert(venmoConfigurationModel))
                .thenReturn(new VenmoConfigurationData());
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration()).thenReturn(hostedFieldsConfigurationModel);
        when(hostedFieldsConfigurationConverter.convert(hostedFieldsConfigurationModel))
                .thenReturn(new HostedFieldsConfigurationData());
        when(payPalPluginConfigurationModel.getConnectWithPayPalConfiguration())
                .thenReturn(connectWithPayPalConfigurationModel);
        when(connectWithPayPalConfigurationConverter
                .convert(connectWithPayPalConfigurationModel)).thenReturn(new ConnectWithPayPalConfigurationData());
        when(payPalPluginConfigurationModel.getApplePayConfiguration())
                .thenReturn(applePayConfigurationModel);
        when(applePayConfigurationConverter
                .convert(applePayConfigurationModel)).thenReturn(new ApplePayConfigurationData());
        when(payPalPluginConfigurationModel.getLocalPaymentsConfiguration())
                .thenReturn(localPaymentsConfigurationModel);
        when(localPaymentsConfigurationConverter
                .convert(localPaymentsConfigurationModel)).thenReturn(new LocalPaymentsConfigurationData());

        unit.getPayPalPluginConfigurationData();

        verify(payPalConfigurationService, times(7)).getPayPalPluginConfiguration();
        verify(payPalPluginConfigurationModel).getPayPalGeneralConfiguration();
        verify(payPalGeneralConfigurationConverter).convert(payPalGeneralConfigurationModel);
        verify(payPalPluginConfigurationModel).getVenmoConfiguration();
        verify(venmoConfigurationConverter).convert(venmoConfigurationModel);
        verify(payPalPluginConfigurationModel).getHostedFieldsConfiguration();
        verify(hostedFieldsConfigurationConverter).convert(hostedFieldsConfigurationModel);
        verify(payPalPluginConfigurationModel).getConnectWithPayPalConfiguration();
        verify(connectWithPayPalConfigurationConverter).convert(connectWithPayPalConfigurationModel);
        verify(payPalPluginConfigurationModel).getApplePayConfiguration();
        verify(applePayConfigurationConverter).convert(applePayConfigurationModel);
        verify(payPalPluginConfigurationModel).getLocalPaymentsConfiguration();
        verify(localPaymentsConfigurationConverter).convert(localPaymentsConfigurationModel);
    }

    @Test
    public void shouldGetPayPalEssentialConfigurationData() {
        when(payPalConfigurationService.getClientID()).thenReturn(CLIENT_ID);
        when(payPalConfigurationService.getPayPalSdkJsUrl()).thenReturn(SDK_JS_URL);
        when(payPalConfigurationService.getPayPalPartnerAttributionId()).thenReturn(ATTRIBUTION_ID);
        when(payPalConfigurationService.getEnvironmentType()).thenReturn(ENVIRONMENT_TYPE);
        when(payPalConfigurationService.getNonDecimalCurrency()).thenReturn(CURRENCY);

        PayPalEssentialConfigurationData result = unit.getPayPalEssentialConfigurationData();

        assertEquals(CLIENT_ID, result.getClientId());
        assertEquals(SDK_JS_URL, result.getPayPalSdkJsUrl());
        assertEquals(ATTRIBUTION_ID, result.getPayPalPartnerAttributionId());
        assertEquals(ENVIRONMENT_TYPE, result.getEnvironmentType());
        assertEquals(CURRENCY, result.getNonDecimalCurrency());
    }

    @Test
    public void shouldGetPayPalFraudNetConfigurationData() {
        when(payPalFraudNetFacade.getCorrelationId()).thenReturn(CORRELATION_ID);
        doNothing().when(payPalFraudNetFacade).saveCorrelationId(CORRELATION_ID);
        when(payPalFraudNetFacade.getPageId(LOGIN_PAGE.toLowerCase(Locale.US))).thenReturn(PAGE_ID);

        PayPalFraudNetConfigurationData result = unit.getPayPalFraudNetConfigurationData(LOGIN_PAGE);

        assertEquals(CORRELATION_ID, result.getCorrelationId());
        assertEquals(PAGE_ID, result.getPageId());
        verify(payPalFraudNetFacade).getCorrelationId();
        verify(payPalFraudNetFacade).saveCorrelationId(CORRELATION_ID);
    }

}