package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.service.PayPalClientTokenService;
import com.paypal.hybris.data.PayPalGenerateClientTokenData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.mockito.Mockito.when;
import static org.mockito.Mockito.verify;
import static org.junit.Assert.assertEquals;

@UnitTest
public class DefaultPayPalClientTokenFacadeTest {

    private static final String CLIENT_TOKEN = "clientToken";

    @Mock
    private PayPalClientTokenService payPalClientTokenService;

    @InjectMocks
    private DefaultPayPalClientTokenFacade unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetClientToken() {
        final PayPalGenerateClientTokenData clientTokenData = new PayPalGenerateClientTokenData();

        clientTokenData.setClientToken(CLIENT_TOKEN);
        when(payPalClientTokenService.getClientToken()).thenReturn(clientTokenData);

        String result = unit.getClientToken();

        assertEquals(CLIENT_TOKEN, result);
        verify(payPalClientTokenService).getClientToken();
    }
}
