package com.paypal.hybris.facade.context;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.acceleratorservices.model.cms2.pages.EmailPageModel;
import de.hybris.platform.acceleratorservices.urlencoder.UrlEncoderService;
import de.hybris.platform.acceleratorservices.urlresolver.SiteBaseUrlResolutionService;
import de.hybris.platform.basecommerce.model.site.BaseSiteModel;
import de.hybris.platform.commerceservices.model.process.StoreFrontCustomerProcessModel;
import de.hybris.platform.core.model.c2l.LanguageModel;
import de.hybris.platform.core.model.user.CustomerModel;
import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalEmailContextTest {

    private static final String PATTERN_FOR_EMAIL = "patternForEmail";
    private static final String BASE_URL = "baseUrl";
    private static final String BASE_THEME_URL = "baseThemeUrl";
    private static final String SECURE_BASE_URL = "secureBaseUrl";
    private static final String MEDIA_BASE_URL = "mediaBaseUrl";
    private static final String MEDIA_SECURE_BASE_URL = "mediaSecureBaseUrl";
    private static final String FROM_EMAIL = "fromEmail";
    private static final String FROM_NAME = "fromName";
    private static final String CUSTOMER_NAME = "customerName";
    private static final String DISPLAY_NAME = "displayName";

    @Mock
    private StoreFrontCustomerProcessModel businessProcessModel;
    @Mock
    private BaseSiteModel baseSiteModel;
    @Mock
    private CustomerModel customerModel;
    @Mock
    private LanguageModel languageModel;
    @Mock
    private EmailPageModel emailPageModel;
    @Mock
    private UrlEncoderService urlEncoderService;
    @Mock
    private SiteBaseUrlResolutionService baseUrlResolutionService;

    @Spy
    @InjectMocks
    private PayPalEmailContext unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        when(businessProcessModel.getSite()).thenReturn(baseSiteModel);
        when(urlEncoderService.getUrlEncodingPatternForEmail(businessProcessModel)).thenReturn(PATTERN_FOR_EMAIL);
        when(baseUrlResolutionService.getWebsiteUrlForSite(baseSiteModel, PATTERN_FOR_EMAIL, false, StringUtils.EMPTY))
                .thenReturn(BASE_URL);
        when(baseUrlResolutionService.getWebsiteUrlForSite(baseSiteModel, false, StringUtils.EMPTY))
                .thenReturn(BASE_THEME_URL);
        when(baseUrlResolutionService.getWebsiteUrlForSite(baseSiteModel, PATTERN_FOR_EMAIL, true, StringUtils.EMPTY))
                .thenReturn(SECURE_BASE_URL);
        when(baseUrlResolutionService.getMediaUrlForSite(baseSiteModel, false)).thenReturn(MEDIA_BASE_URL);
        when(baseUrlResolutionService.getMediaUrlForSite(baseSiteModel, true)).thenReturn(MEDIA_SECURE_BASE_URL);
        when(emailPageModel.getFromEmail()).thenReturn(FROM_EMAIL);
        when(businessProcessModel.getLanguage()).thenReturn(null);
        when(emailPageModel.getFromName()).thenReturn(FROM_NAME);
        when(businessProcessModel.getCustomer()).thenReturn(null).thenReturn(customerModel);
        when(customerModel.getName()).thenReturn(CUSTOMER_NAME);
    }

    @Test
    public void shouldInit() {
        unit.init(businessProcessModel, emailPageModel);

        verify(businessProcessModel, times(2)).getCustomer();
        verify(customerModel).getName();
    }

    @Test
    public void shouldInitWhenDisplayIsAbsent() {
        when(unit.internalGet(DISPLAY_NAME)).thenReturn(new Object());

        unit.init(businessProcessModel, emailPageModel);

        verify(businessProcessModel, times(1)).getCustomer();
        verify(customerModel, times(0)).getName();
    }

    @Test
    public void shouldGetSite() {
        when(businessProcessModel.getSite()).thenReturn(baseSiteModel);

        unit.getSite(businessProcessModel);

        verify(businessProcessModel).getSite();
    }

    @Test
    public void shouldGetCustomer() {
        when(businessProcessModel.getCustomer()).thenReturn(customerModel);

        unit.getCustomer(businessProcessModel);

        verify(businessProcessModel).getCustomer();
    }

    @Test
    public void shouldGetEmailLanguage() {
        when(businessProcessModel.getLanguage()).thenReturn(languageModel);

        unit.getEmailLanguage(businessProcessModel);

        verify(businessProcessModel).getLanguage();
    }

}