package com.paypal.hybris.facade.builders;

import com.paypal.hybris.addon.forms.PaymentTokenData;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.PayPalPaymentInfoService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.PK;
import de.hybris.platform.core.model.user.CustomerModel;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Optional;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

@UnitTest
public class TokenRequestDirectorTest {

    private static final String SETUP_TOKEN_VALUE = "SETUP_TOKEN";
    private static final String VAULT_CUSTOMER_ID_VALUE = "customerId";

    @Mock
    private CustomerModel customerModel;
    private PaypalGetPaymentTokenRequestBuilder builder;
    private PaymentTokenData paymentTokenData;
    @Mock
    private PayPalPaymentInfoService payPalPaymentInfoService;
    @Mock
    private PayPalCreditCardPaymentInfoModel paymentInfoModel;

    @InjectMocks
    private TokenRequestDirector unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        builder = new PaypalGetPaymentTokenRequestBuilder();
        paymentTokenData = new PaymentTokenData();
        paymentTokenData.setSetupToken(SETUP_TOKEN_VALUE);
        paymentTokenData.setPaymentInfoPK(PK.BIG_PK.getLongValueAsString());
    }

    @Test
    public void shouldSetCustomerIdWhenPaymentInfoExists() {
        when(payPalPaymentInfoService.getPaymentInfoByPK(paymentTokenData.getPaymentInfoPK()))
                .thenReturn(Optional.of(paymentInfoModel));
        when(paymentInfoModel.getUser()).thenReturn(customerModel);
        when(customerModel.getVaultCustomerId()).thenReturn(VAULT_CUSTOMER_ID_VALUE);

        unit.constructGetPaymentTokenRequest(builder, paymentTokenData);

        assertEquals(VAULT_CUSTOMER_ID_VALUE, builder.getResult().getCustomer().getId());
        assertEquals(SETUP_TOKEN_VALUE, builder.getResult().getPaymentSource().getToken().getId());
    }

    @Test(expected = IllegalArgumentException.class)
    public void shouldThrowExceptionWhenPaymentInfoNotFound() {
        when(payPalPaymentInfoService.getPaymentInfoByPK(paymentTokenData.getPaymentInfoPK()))
                .thenReturn(Optional.empty());

        unit.constructGetPaymentTokenRequest(builder, paymentTokenData);
    }

}
