package com.paypal.hybris.facade.builders;

import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Test;

import static org.junit.Assert.assertEquals;

@UnitTest
public class PaypalGetPaymentTokenRequestBuilderTest {

    private static final String SETUP_TOKEN_VALUE = "SETUP_TOKEN";
    private static final String CUSTOMER_ID_VALUE = "customerId";
    private static final String TOKEN_ID_VALUE = "tokenId";

    private final PaypalGetPaymentTokenRequestBuilder unit = new PaypalGetPaymentTokenRequestBuilder();

    @Test
    public void shouldGetResult() {
        unit.setCustomerId(CUSTOMER_ID_VALUE);
        unit.setSetupTokenId(TOKEN_ID_VALUE);

        var result = unit.getResult();

        assertEquals(SETUP_TOKEN_VALUE, result.getPaymentSource().getToken().getType());
        assertEquals(TOKEN_ID_VALUE, result.getPaymentSource().getToken().getId());
        assertEquals(CUSTOMER_ID_VALUE, result.getCustomer().getId());
    }

}
