package com.paypal.hybris.facade.strategy.payment.impl;

import com.paypal.enums.PayPalPaymentProvider;
import com.paypal.hybris.core.service.PayPalCustomerAccountService;
import com.paypal.hybris.data.ExperienceContextData;
import com.paypal.hybris.data.PayPalCustomerData;
import com.paypal.hybris.data.PayPalData;
import com.paypal.hybris.data.PayPalPaymentSource;
import com.paypal.hybris.data.PayPalSavePaymentForPurchaseLaterRequest;
import com.paypal.hybris.data.SetupTokenRequestData;
import com.paypal.hybris.facade.strategy.payment.PaymentStrategy;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import de.hybris.platform.servicelayer.user.UserService;
import org.apache.commons.lang3.StringUtils;

import java.util.Optional;

public class DefaultPayPalPopulatorStrategy implements PaymentStrategy {

    private static final String MY_ACCOUNT_PAYMENT_DETAILS_APPROVE_LINK = "https://example.com/returnUrl";
    private static final String MY_ACCOUNT_PAYMENT_DETAILS_CANCEL_LINK = "https://example.com/cancelUrl";
    private static final String USAGE_TYPE = "MERCHANT";
    private PayPalCustomerAccountService payPalCustomerAccountService;

    @Override
    public void populate(SetupTokenRequestData setupTokenRequestData, PayPalSavePaymentForPurchaseLaterRequest request) throws ConversionException {
        final PayPalData payPalData = new PayPalData();

        payPalData.setExperienceContext(getExperienceContextData());
        payPalData.setUsageType(USAGE_TYPE);
        request.setPaymentSource(getPaymentSource(payPalData));
        request.setCustomer(getCustomerData(setupTokenRequestData));
    }

    private static PayPalPaymentSource getPaymentSource(PayPalData payPalData) {
        final PayPalPaymentSource paymentSource = new PayPalPaymentSource();
        paymentSource.setPaypal(payPalData);
        return paymentSource;
    }


    private static ExperienceContextData getExperienceContextData() {
        final ExperienceContextData experienceContext = new ExperienceContextData();

        experienceContext.setReturnUrl(MY_ACCOUNT_PAYMENT_DETAILS_APPROVE_LINK);
        experienceContext.setCancelUrl(MY_ACCOUNT_PAYMENT_DETAILS_CANCEL_LINK);
        return experienceContext;
    }
    private PayPalCustomerData getCustomerData(SetupTokenRequestData requestData) {
        final PayPalCustomerData customerData = new PayPalCustomerData();
        setCustomerId(requestData, customerData);
        return customerData;
    }

    private void setCustomerId(SetupTokenRequestData requestData, PayPalCustomerData customerData) {
        CustomerModel customerModel = payPalCustomerAccountService.getCustomerModel(requestData.getPayerId());

        if (StringUtils.isNotEmpty(customerModel.getVaultCustomerId())) {
            customerData.setId(customerModel.getVaultCustomerId());
        }
    }

    @Override
    public boolean test(PayPalPaymentProvider paymentProvider) {
        return paymentProvider.equals(PayPalPaymentProvider.PAYPAL);
    }

    public void setPayPalCustomerAccountService(PayPalCustomerAccountService payPalCustomerAccountService) {
        this.payPalCustomerAccountService = payPalCustomerAccountService;
    }

}
