package com.paypal.hybris.facade.strategy.configuration.page.impl;

import com.paypal.enums.PayPalPageType;
import com.paypal.hybris.data.PaypalGeneralPageConfigurationData;
import com.paypal.hybris.data.PaypalPageSpecificConfigurationData;
import com.paypal.hybris.facade.strategy.configuration.page.PageConfigurationStrategy;


public class LoginPageConfigurationStrategy extends BasePageConfigurationStrategy implements PageConfigurationStrategy {

    @Override
    public PaypalGeneralPageConfigurationData getConfiguration() {
        final PaypalGeneralPageConfigurationData generalPageConfigurationData = getPayPalGeneralPageConfiguration();
        final PaypalPageSpecificConfigurationData pageSpecificConfiguration = generalPageConfigurationData.getPaypalPageSpecificConfiguration();

        pageSpecificConfiguration.setPayPalConnectScopes(getPayPalConfigurationService().getPayPalConnectScopes());
        pageSpecificConfiguration.setPayPalConnectResponseType(getPayPalConfigurationService().getPayPalConnectResponseType());
        pageSpecificConfiguration.setPayPalConnectReturnUrl(getPayPalConfigurationService().getPayPalConnectReturnUrl());
        pageSpecificConfiguration.setPayPalConnectScript(getPayPalConfigurationService().getPayPalConnectScript());

        return generalPageConfigurationData;
    }

    @Override
    public boolean test(PayPalPageType pageType) {
        return PayPalPageType.LOGIN.equals(pageType);
    }
}
