package com.paypal.hybris.facade.strategy.configuration.page.impl;

import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.PaypalGeneralPageConfigurationData;
import com.paypal.hybris.data.PaypalPageSpecificConfigurationData;
import com.paypal.hybris.facade.facades.PayPalClientTokenFacade;
import com.paypal.hybris.facade.facades.PayPalConfigurationFacade;
import de.hybris.platform.catalog.CatalogVersionService;
import de.hybris.platform.catalog.model.CatalogVersionModel;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.core.model.media.MediaModel;
import de.hybris.platform.servicelayer.exceptions.UnknownIdentifierException;
import de.hybris.platform.servicelayer.i18n.I18NService;
import de.hybris.platform.servicelayer.media.MediaService;
import org.apache.commons.lang.StringUtils;

import java.util.Optional;

class BasePageConfigurationStrategy {

    private static final String VENMO_LOGO = "venmoLogo";
    private static final String APPLE_PAY_LOGO = "applePayLogo";

    private MediaService mediaService;
    private I18NService i18NService;
    private PayPalConfigurationService payPalConfigurationService;
    private CatalogVersionService catalogVersionService;
    private CartFacade cartFacade;
    private PayPalClientTokenFacade payPalClientTokenFacade;
    private PayPalConfigurationFacade payPalConfigurationFacade;

    protected PaypalGeneralPageConfigurationData getPayPalGeneralPageConfiguration() {
        return GenericBuilder.of(PaypalGeneralPageConfigurationData::new)
                .with(PaypalGeneralPageConfigurationData::setPaypalPageSpecificConfiguration, getPayPalPageSpecificConfiguration())
                .with(PaypalGeneralPageConfigurationData::setPayPalPluginConfiguration, payPalConfigurationFacade.getPayPalPluginConfigurationData())
                .with(PaypalGeneralPageConfigurationData::setPayPalEssentialConfiguration, payPalConfigurationFacade.getPayPalEssentialConfigurationData())
                .build();
    }

    private PaypalPageSpecificConfigurationData getPayPalPageSpecificConfiguration() {
        return GenericBuilder.of(PaypalPageSpecificConfigurationData::new)
                .with(PaypalPageSpecificConfigurationData::setVenmoIconUrl, getImageUrlByCode(VENMO_LOGO))
                .with(PaypalPageSpecificConfigurationData::setApplePayIconUrl, getImageUrlByCode(APPLE_PAY_LOGO))
                .with(PaypalPageSpecificConfigurationData::setCurrency, i18NService.getCurrentJavaCurrency().getCurrencyCode())
                .build();
    }

    private String getImageUrlByCode(String code) {
        String imgUrl = null;
        if (StringUtils.isNotEmpty(code)) {
            for (final CatalogVersionModel catalogVersionModel : catalogVersionService.getSessionCatalogVersions()) {
                try {
                    final MediaModel media = mediaService.getMedia(catalogVersionModel, code);
                    imgUrl = Optional.ofNullable(media).map(MediaModel::getDownloadURL).orElse(null);
                } catch (final UnknownIdentifierException ignore) {
                    // Ignore this exception
                }
            }
        }
        return imgUrl;
    }

    public void setCartFacade(CartFacade cartFacade) {
        this.cartFacade = cartFacade;
    }

    public void setMediaService(MediaService mediaService) {
        this.mediaService = mediaService;
    }

    public void setI18NService(I18NService i18NService) {
        this.i18NService = i18NService;
    }

    public void setPayPalConfigurationService(PayPalConfigurationService payPalConfigurationService) {
        this.payPalConfigurationService = payPalConfigurationService;
    }

    public void setCatalogVersionService(CatalogVersionService catalogVersionService) {
        this.catalogVersionService = catalogVersionService;
    }

    public PayPalConfigurationService getPayPalConfigurationService() {
        return payPalConfigurationService;
    }

    public CartFacade getCartFacade() {
        return cartFacade;
    }

    public PayPalClientTokenFacade getPayPalClientTokenFacade() {
        return payPalClientTokenFacade;
    }

    public void setPayPalClientTokenFacade(PayPalClientTokenFacade payPalClientTokenFacade) {
        this.payPalClientTokenFacade = payPalClientTokenFacade;
    }

    public void setPayPalConfigurationFacade(PayPalConfigurationFacade payPalConfigurationFacade) {
        this.payPalConfigurationFacade = payPalConfigurationFacade;
    }

}
