package com.paypal.hybris.facade.strategy.configuration.page.impl;

import com.paypal.enums.PayPalPageType;
import com.paypal.hybris.data.PaypalGeneralPageConfigurationData;
import com.paypal.hybris.data.PaypalPageSpecificConfigurationData;
import com.paypal.hybris.facade.strategy.configuration.page.PageConfigurationStrategy;

public class AccountPageConfigurationStrategy extends BasePageConfigurationStrategy implements PageConfigurationStrategy {

    @Override
    public PaypalGeneralPageConfigurationData getConfiguration() {
        final PaypalGeneralPageConfigurationData generalPageConfigurationData = getPayPalGeneralPageConfiguration();
        final PaypalPageSpecificConfigurationData pageSpecificConfiguration = generalPageConfigurationData.getPaypalPageSpecificConfiguration();

        if (getPayPalConfigurationService().isPayPalHostedFieldsEnabled() && getPayPalConfigurationService().isPayPalHostedFieldsVaultEnabled()) {
            pageSpecificConfiguration.setClientToken(getPayPalClientTokenFacade().getClientToken());
        }

        return generalPageConfigurationData;
    }

    @Override
    public boolean test(PayPalPageType page) {
        return PayPalPageType.ACCOUNT.equals(page);
    }
}
