package com.paypal.hybris.facade.service.impl;


import com.paypal.hybris.core.model.ApplePayConfigurationModel;
import com.paypal.hybris.core.model.ApplePayStylesConfigurationModel;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;
import com.paypal.hybris.core.model.HostedFieldsStylesConfigurationModel;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import com.paypal.hybris.core.model.PayPalPluginConfigurationModel;
import com.paypal.hybris.core.model.PayPalStylesConfigurationModel;
import com.paypal.hybris.facade.service.StylesConfigurationService;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.store.BaseStoreModel;
import de.hybris.platform.store.services.BaseStoreService;
import org.apache.log4j.Logger;

import java.util.Optional;

public class DefaultStylesConfigurationService implements StylesConfigurationService {

    private static final Logger LOG = Logger.getLogger(DefaultStylesConfigurationService.class);

    private BaseStoreService baseStoreService;
    private ModelService modelService;

    @Override
    public HostedFieldsStylesConfigurationModel getHostedFieldsStylesConfiguration() {
        return Optional.ofNullable(baseStoreService.getCurrentBaseStore())
                .map(BaseStoreModel::getPayPalPluginConfiguration)
                .map(PayPalPluginConfigurationModel::getHostedFieldsConfiguration)
                .map(HostedFieldsConfigurationModel::getHostedFieldsStylesConfiguration)
                .orElseGet(this::getDefaultHostedFieldsStylesConfiguration);
    }

    @Override
    public PayPalStylesConfigurationModel getPayPalStylesConfiguration(String location) {
        return Optional.ofNullable(baseStoreService.getCurrentBaseStore())
                .map(BaseStoreModel::getPayPalPluginConfiguration)
                .map(PayPalPluginConfigurationModel::getPayPalConfiguration)
                .map(PayPalConfigurationModel::getPayPalStylesConfiguration).flatMap(stylesConfigurations -> stylesConfigurations.stream()
                        .filter(model -> location.equalsIgnoreCase(model.getLocation().name()))
                        .findFirst())
                .orElseGet(this::getDefaultPayPalStylesConfiguration);
    }

    @Override
    public ApplePayStylesConfigurationModel getApplePayStylesConfiguration(String location) {
        return Optional.ofNullable(baseStoreService.getCurrentBaseStore())
                .map(BaseStoreModel::getPayPalPluginConfiguration)
                .map(PayPalPluginConfigurationModel::getApplePayConfiguration)
                .map(ApplePayConfigurationModel::getApplePayStylesConfiguration).flatMap(stylesConfigurations -> stylesConfigurations.stream()
                        .filter(model -> location.equalsIgnoreCase(model.getLocation().name()))
                        .findFirst())
                .orElseGet(this::getDefaultApplePayStylesConfiguration);
    }

    private PayPalStylesConfigurationModel getDefaultPayPalStylesConfiguration() {
        LOG.warn("PayPalStylesConfiguration is not found! Using default values!");
        return modelService.create(PayPalStylesConfigurationModel.class);
    }

    private ApplePayStylesConfigurationModel getDefaultApplePayStylesConfiguration() {
        LOG.warn("ApplePayStylesConfiguration is not found! Using default values!");
        return modelService.create(ApplePayStylesConfigurationModel.class);
    }

    private HostedFieldsStylesConfigurationModel getDefaultHostedFieldsStylesConfiguration() {
        LOG.warn("HostedFieldsStylesConfiguration is not found! Using default values!");
        return modelService.create(HostedFieldsStylesConfigurationModel.class);
    }

    public void setBaseStoreService(BaseStoreService baseStoreService) {
        this.baseStoreService = baseStoreService;
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

}
