package com.paypal.hybris.facade.service;

import de.hybris.platform.core.model.order.AbstractOrderModel;

import java.math.BigDecimal;

public interface BreakdownAmountCalculationService {

	BigDecimal calculateTotalDiscount(AbstractOrderModel orderModel);

	BigDecimal calculateTotalAmount(AbstractOrderModel abstractOrderModel);

	BigDecimal calculateItemsAmount(AbstractOrderModel abstractOrderModel);

	default BigDecimal calculateTaxAmount(AbstractOrderModel abstractOrderModel) {
		Double totalTax = (abstractOrderModel.getNet() && abstractOrderModel.getStore() != null
				&& abstractOrderModel.getStore().getExternalTaxEnabled()) ? abstractOrderModel.getTotalTax() : Double.valueOf(0d);
		return BigDecimal.valueOf(totalTax);
	}
}
