package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.model.PayPalStylesConfigurationModel;
import com.paypal.hybris.data.PayPalStylesConfigurationData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

public class PayPalStylesConfigPopulator implements Populator<PayPalStylesConfigurationModel, PayPalStylesConfigurationData> {

    @Override
    public void populate(final PayPalStylesConfigurationModel source, final PayPalStylesConfigurationData target)
            throws ConversionException {
        target.setLocation(source.getLocation().name().toLowerCase());
        target.setColor(source.getColor().name().toLowerCase());
        target.setShape(source.getShape().name().toLowerCase());
        target.setLabel(source.getLabel().name().toLowerCase());
        target.setBorderRadius(source.getBorderRadius());
        target.setHeight(source.getHeight());
    }
}
