package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.model.PayPalGeneralConfigurationModel;
import com.paypal.hybris.data.PayPalGeneralConfigurationData;
import com.paypal.hybris.data.PayPalGenerateClientTokenData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_AUTHORIZE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_CAPTURE;

public class PayPalGeneralConfigurationDataPopulator implements Populator<PayPalGeneralConfigurationModel, PayPalGeneralConfigurationData> {
    @Override
    public void populate(PayPalGeneralConfigurationModel source, PayPalGeneralConfigurationData target) throws ConversionException {
        target.setBuyerCountry(source.getBuyerCountry());
        target.setPayPalIntent(getPayPalIntent(source));
        target.setFraudNetIntegration(source.isFraudNetIntegration());
        target.setFraudNetSandbox(source.isFraudNetSandbox());
        target.setLocale(source.getLocale());
    }

    private static String getPayPalIntent(PayPalGeneralConfigurationModel source) {
        return source.isSettleImmediately() ? PAYPAL_INTENT_CAPTURE : PAYPAL_INTENT_AUTHORIZE;
    }
}
