package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.model.PayPalConfigurationModel;
import com.paypal.hybris.data.PayPalConfigurationData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

public class PayPalConfigurationDataPopulator implements Populator<PayPalConfigurationModel, PayPalConfigurationData> {
    @Override
    public void populate(PayPalConfigurationModel source, PayPalConfigurationData target) throws ConversionException {
        target.setPayPalEnable(source.isPayPalEnable());
        target.setExpressCheckoutEnable(source.isExpressCheckoutEnable());
        target.setPayLaterForNonUsCountries(source.isPayLaterForNonUsCountries());
        target.setPayPalFundingOnBillingPage(source.getPayPalFundingOnBillingPage());
        target.setPayPalFundingOnExpressCheckout(source.getPayPalFundingOnExpressCheckout());
        target.setVaultEnabled(source.isVaultEnabled());
        target.setChangePaymentButtonEnabled(source.isChangePaymentButtonEnabled());
        target.setSavedPayPalAccountsLimit(source.getSavedPayPalAccountsLimit());
    }

}
