package com.paypal.hybris.facade.populator;

import de.hybris.platform.commercefacades.user.data.AddressData;
import com.paypal.hybris.data.AddressPortableData;
import de.hybris.platform.commercefacades.user.data.CountryData;
import de.hybris.platform.commercefacades.user.data.RegionData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import org.apache.commons.lang.StringUtils;

import java.util.Optional;

public class PayPalAddressPortableDataPopulator implements Populator<AddressData, AddressPortableData> {
    @Override
    public void populate(AddressData source, AddressPortableData target) throws ConversionException {
        String regionIsoCode = Optional.ofNullable(source.getRegion()).map(RegionData::getIsocodeShort).orElse(StringUtils.EMPTY);
        String countryIsoCode = Optional.ofNullable(source.getCountry()).map(CountryData::getIsocode).orElse(StringUtils.EMPTY);

        target.setAddressLine1(source.getLine1());
        target.setAddressLine2(source.getLine2());
        target.setAdminArea1(regionIsoCode);
        target.setAdminArea2(source.getTown());
        target.setCountryCode(countryIsoCode);
        target.setPostalCode(source.getPostalCode());
    }
}
