package com.paypal.hybris.facade.populator;

import com.paypal.hybris.data.PayPalAddressDetailsData;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.commercefacades.user.data.CountryData;
import de.hybris.platform.commercefacades.user.data.RegionData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;


public class PayPalAddressDataPopulator implements Populator<PayPalAddressDetailsData, AddressData> {

    @Override
    public void populate(final PayPalAddressDetailsData source, final AddressData target)
        throws ConversionException {
        target.setFirstName(source.getFirstName());
        target.setLastName(source.getLastName());
        target.setEmail(source.getEmail());
        if (source.getCountryCode() != null) {
            final CountryData country = new CountryData();
            country.setIsocode(source.getCountryCode());
            target.setCountry(country);
        }
        if (source.getRegion() != null) {
            final RegionData region = new RegionData();
            region.setIsocode(source.getCountryCode() + "-" + source.getRegion());
            target.setRegion(region);
        }
        target.setLine1(source.getLine1());
        target.setLine2(source.getLine2());
        target.setPostalCode(source.getPostalCode());
        target.setTown(source.getCity());
    }
}
