package com.paypal.hybris.facade.populator;

import de.hybris.platform.commercefacades.order.data.OrderEntryData;
import de.hybris.platform.commercefacades.product.data.PriceData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.core.model.order.AbstractOrderEntryModel;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import de.hybris.platform.util.DiscountValue;
import de.hybris.platform.util.TaxValue;

import java.math.BigDecimal;

public class PayPaCartEntryL2L3DataPopulator implements Populator<AbstractOrderEntryModel, OrderEntryData> {

    @Override
    public void populate(AbstractOrderEntryModel source, OrderEntryData target) throws ConversionException {
        String currency = source.getOrder().getCurrency().getIsocode();
        target.setTaxAmount(String.valueOf(source.getTaxValues()
                .stream()
                .mapToDouble(TaxValue::getAppliedValue)
                .sum()));

        target.setDiscountAmount(String.valueOf(source.getDiscountValues()
                .stream()
                .mapToDouble(DiscountValue::getValue)
                .sum()));
        PriceData totalPrice = new PriceData();
        totalPrice.setValue(BigDecimal.valueOf(source.getTotalPrice()));
        totalPrice.setCurrencyIso(currency);

        target.setTotalPrice(totalPrice);
        target.setUnitOfMeasure(source.getUnit().getUnitType());
    }
}
