package com.paypal.hybris.facade.populator;

import com.paypal.hybris.data.L3ItemData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.core.model.order.AbstractOrderEntryModel;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import de.hybris.platform.util.DiscountValue;
import de.hybris.platform.util.TaxValue;
import org.apache.commons.lang3.StringUtils;

import static com.paypal.hybris.core.util.PayPalCommandsUtil.createAmount;

public class L3ItemDataPopulator implements Populator<AbstractOrderEntryModel, L3ItemData> {

    private static final int MAX_DESCRIPTION_LENGTH = 127;

    @Override
    public void populate(AbstractOrderEntryModel source, L3ItemData target) throws ConversionException {
        String currency = source.getOrder().getCurrency().getIsocode();

        double tax = source.getTaxValues()
                .stream()
                .mapToDouble(TaxValue::getAppliedValue)
                .sum();

        double discountAmount = source.getDiscountValues()
                .stream()
                .mapToDouble(DiscountValue::getValue)
                .sum();

        target.setUnitOfMeasure(source.getUnit().getUnitType());
        target.setName(source.getProduct().getName());
        target.setQuantity(source.getQuantity().intValue());
        target.setDescription(StringUtils.abbreviate(source.getProduct().getDescription(),
                MAX_DESCRIPTION_LENGTH));
        target.setSku(source.getProduct().getCode());
        target.setAmount(createAmount(source.getBasePrice(), currency));
        target.setTax(createAmount(tax, currency));
        target.setDiscountAmount(createAmount(discountAmount, currency));
        target.setTotalAmount(createAmount(source.getTotalPrice(), currency));
    }
}
