package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.model.HostedFieldsStylesConfigurationModel;
import com.paypal.hybris.data.HostedFieldsStylesConfigurationData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

public class HostedFieldsStylesConfigPopulator implements Populator<HostedFieldsStylesConfigurationModel, HostedFieldsStylesConfigurationData> {

    @Override
    public void populate(final HostedFieldsStylesConfigurationModel source, final HostedFieldsStylesConfigurationData target)
            throws ConversionException {
        target.setInputColor(source.getInputColor().name().toLowerCase());
        target.setInvalidColor(source.getInvalidColor().name().toLowerCase());
        target.setValidColor(source.getValidColor().name().toLowerCase());
        target.setFontSize(source.getFontSize() + "px");
    }
}
