package com.paypal.hybris.facade.populator;

import com.paypal.enums.SavedPaymentMethodsLimit;
import com.paypal.enums.ThreeDsVerificationOnMyAccountType;
import com.paypal.enums.ThreeDsVerificationType;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;
import com.paypal.hybris.data.HostedFieldsConfigurationData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

public class HostedFieldsConfigurationDataPopulator implements Populator<HostedFieldsConfigurationModel, HostedFieldsConfigurationData> {
    @Override
    public void populate(HostedFieldsConfigurationModel source, HostedFieldsConfigurationData target) throws ConversionException {
        target.setEnable(source.isEnable());
        target.setExpireBetween(source.getExpireBetween());
        target.setExpireOnAdding(source.isExpireOnAdding());
        target.setVaultFlow(source.isVaultFlow());
        target.setThreeDsVerificationOnCheckout(ThreeDsVerificationType.valueOf(source.getThreeDsVerificationOnCheckout().getCode()));
        target.setVerificationOnMyAccount(ThreeDsVerificationOnMyAccountType.valueOf(source.getVerificationOnMyAccount().getCode()));
        target.setSavedCreditCardsLimit(SavedPaymentMethodsLimit.valueOf(source.getSavedCreditCardsLimit().getCode()));
    }
}
