package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.model.ConnectWithPayPalConfigurationModel;
import com.paypal.hybris.data.ConnectWithPayPalConfigurationData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

public class ConnectWithPayPalConfigurationDataPopulator implements Populator<ConnectWithPayPalConfigurationModel, ConnectWithPayPalConfigurationData> {
    @Override
    public void populate(ConnectWithPayPalConfigurationModel source, ConnectWithPayPalConfigurationData target) throws ConversionException {
        target.setEnable(source.isEnable());
        target.setAdditionalSecurity(source.isAdditionalSecurity());
        target.setAddPaymentMethodFlow(source.isAddPaymentMethodFlow());
        target.setLinkUserAccount(source.isLinkUserAccount());
    }
}
