package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.model.ApplePayStylesConfigurationModel;
import com.paypal.hybris.data.ApplePayStylesConfigurationData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import org.apache.commons.lang.StringUtils;

public class ApplePayStylesConfigPopulator implements Populator<ApplePayStylesConfigurationModel, ApplePayStylesConfigurationData> {

    private static final String UNDERSCORE = "_";
    private static final String DASH = "-";

    @Override
    public void populate(final ApplePayStylesConfigurationModel source, final ApplePayStylesConfigurationData target)
            throws ConversionException {
        target.setLocation(source.getLocation().name().toLowerCase());
        target.setColor(formatConfigValue(source.getButtonColor().name().toLowerCase()));
        target.setType(formatConfigValue(source.getButtonType().name().toLowerCase()));
    }

    private String formatConfigValue(String value) {
        if (StringUtils.isNotBlank(value)) {
            value = value.replace(UNDERSCORE, DASH);
        }
        return value;
    }

}
