package com.paypal.hybris.facade.populator;

import com.paypal.hybris.data.ApplePayAddressDetailsData;
import com.paypal.hybris.data.PayPalAddressDetailsData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import org.apache.commons.lang.StringUtils;

import java.util.List;
import java.util.Optional;


public class ApplePayPayPalAddressDataPopulator implements Populator<ApplePayAddressDetailsData, PayPalAddressDetailsData> {

    @Override
    public void populate(ApplePayAddressDetailsData source, PayPalAddressDetailsData target) throws ConversionException {
        Optional<List<String>> addressLines = Optional.ofNullable(source.getAddressLines());

        target.setRegion(source.getAdministrativeArea());
        target.setCity(source.getLocality());
        target.setCountryCode(source.getCountryCode());
        target.setLine1(addressLines.orElse(List.of(StringUtils.EMPTY)).get(0));
        target.setPostalCode(source.getPostalCode());
        target.setFirstName(source.getGivenName());
        target.setLastName(source.getFamilyName());
        target.setEmail(source.getEmailAddress());
        target.setPhone(source.getPhoneNumber());
    }

}
