package com.paypal.hybris.facade.populator;

import com.paypal.hybris.data.ApplePayAddressDetailsData;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.commercefacades.user.data.RegionData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;


public class ApplePayAddressDataReversePopulator implements Populator<AddressData, ApplePayAddressDetailsData> {

    @Override
    public void populate(AddressData source, ApplePayAddressDetailsData target) throws ConversionException {
        List<String> addressLines = new ArrayList<>(List.of(source.getLine1()));
        Optional.ofNullable(source.getLine2()).ifPresent(addressLines::add);

        target.setId(source.getId());
        target.setAdministrativeArea(getAdminArea(source));
        target.setLocality(source.getTown());
        target.setCountry(source.getCountry().getName());
        target.setCountryCode(source.getCountry().getIsocode());
        target.setAddressLines(addressLines);
        target.setPostalCode(source.getPostalCode());
        target.setGivenName(source.getFirstName());
        target.setFamilyName(source.getLastName());
        target.setEmailAddress(source.getEmail());
        target.setPhoneNumber(source.getPhone());
    }

    protected String getAdminArea(AddressData source) {
        return Optional.ofNullable(source.getRegion())
                .map(RegionData::getIsocodeShort)
                .orElse(StringUtils.EMPTY);
    }

}
