package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.model.ApplePayStylesConfigurationModel;
import com.paypal.hybris.core.model.HostedFieldsStylesConfigurationModel;
import com.paypal.hybris.core.model.PayPalStylesConfigurationModel;
import com.paypal.hybris.data.ApplePayStylesConfigurationData;
import com.paypal.hybris.data.PayPalStylesConfigurationData;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import com.paypal.hybris.facade.facades.StylesConfigurationFacade;
import com.paypal.hybris.data.HostedFieldsStylesConfigurationData;
import com.paypal.hybris.facade.service.StylesConfigurationService;

public class DefaultStylesConfigurationFacade implements StylesConfigurationFacade {
    private StylesConfigurationService defaultStylesConfigurationService;
    private Converter<HostedFieldsStylesConfigurationModel, HostedFieldsStylesConfigurationData> hostedFieldsStylesConverter;
    private Converter<PayPalStylesConfigurationModel, PayPalStylesConfigurationData> payPalStylesConverter;
    private Converter<ApplePayStylesConfigurationModel, ApplePayStylesConfigurationData> applePayStylesConverter;


    @Override
    public HostedFieldsStylesConfigurationData getHostedFieldsStylesConfiguration() {
        return hostedFieldsStylesConverter.convert(defaultStylesConfigurationService.getHostedFieldsStylesConfiguration());
    }

    @Override
    public PayPalStylesConfigurationData getPayPalStylesConfiguration(String location) {
        return payPalStylesConverter.convert(defaultStylesConfigurationService.getPayPalStylesConfiguration(location));
    }

    @Override
    public ApplePayStylesConfigurationData getApplePayStylesConfiguration(String location) {
        return applePayStylesConverter.convert(defaultStylesConfigurationService.getApplePayStylesConfiguration(location));
    }

    public void setDefaultStylesConfigurationService(StylesConfigurationService defaultStylesConfigurationService) {
        this.defaultStylesConfigurationService = defaultStylesConfigurationService;
    }

    public void setHostedFieldsStylesConverter(Converter<HostedFieldsStylesConfigurationModel, HostedFieldsStylesConfigurationData> hostedFieldsStylesConverter) {
        this.hostedFieldsStylesConverter = hostedFieldsStylesConverter;
    }

    public void setPayPalStylesConverter(Converter<PayPalStylesConfigurationModel, PayPalStylesConfigurationData> payPalStylesConverter) {
        this.payPalStylesConverter = payPalStylesConverter;
    }

    public void setApplePayStylesConverter(Converter<ApplePayStylesConfigurationModel, ApplePayStylesConfigurationData> applePayStylesConverter) {
        this.applePayStylesConverter = applePayStylesConverter;
    }

}
