package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.enums.PaymentProvider;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.user.impl.DefaultUserFacade;
import de.hybris.platform.core.model.order.payment.CreditCardPaymentInfoModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.core.model.user.CustomerModel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultPaypalUserFacade extends DefaultUserFacade {

    private PayPalConfigurationService configurationService;

    @Override
    public List<CCPaymentInfoData> getCCPaymentInfos(boolean saved) {
        CustomerModel currentCustomer;
        try {
            currentCustomer = getCurrentUserForCheckout();
        } catch (IllegalStateException e) {
            return Collections.emptyList();
        }

        List<CreditCardPaymentInfoModel> creditCards = getCustomerAccountService()
                .getCreditCardPaymentInfos(currentCustomer, saved);

            creditCards = creditCards.stream().map(PayPalCreditCardPaymentInfoModel.class::cast)
                    .filter(this::restrictPaymentInfoRelatedToConfig)
                    .collect(Collectors.toList());

        List<CCPaymentInfoData> ccPaymentInfos = new ArrayList<>();
        PaymentInfoModel defaultPaymentInfoModel = currentCustomer.getDefaultPaymentInfo();
        for (CreditCardPaymentInfoModel ccPaymentInfoModel : creditCards) {
            CCPaymentInfoData paymentInfoData = getCreditCardPaymentInfoConverter().convert(ccPaymentInfoModel);
            if (ccPaymentInfoModel.equals(defaultPaymentInfoModel)) {
                paymentInfoData.setDefaultPaymentInfo(true);
                ccPaymentInfos.add(0, paymentInfoData);
            } else {
                ccPaymentInfos.add(paymentInfoData);
            }
        }
        return ccPaymentInfos;
    }

    private boolean restrictPaymentInfoRelatedToConfig(PayPalCreditCardPaymentInfoModel info) {
        if (PaymentProvider.PAYPAL_HOSTED_FIELDS.equals(info.getPaymentProvider())) {
            return configurationService.isPayPalHostedFieldsEnabled();
        } else if (PaymentProvider.PAYPAL.equals(info.getPaymentProvider())) {
            return configurationService.isPayPalEnable();
        } else if (PaymentProvider.APPLEPAY.equals(info.getPaymentProvider())) {
            return configurationService.isApplePayEnable();
        } else {
            return true;
        }
    }

    public void setConfigurationService(PayPalConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

}
