package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.facade.facades.PayPalSetUpPasswordFacade;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.user.UserService;


public class DefaultPayPalSetUpPasswordFacade implements PayPalSetUpPasswordFacade {

	private UserService userService;
	private ModelService modelService;

	@Override
	public void setUpPassword(String password) {
		final CustomerModel currentCustomer = (CustomerModel) userService.getCurrentUser();
		userService.setPassword(currentCustomer, password, currentCustomer.getPasswordEncoding());
		currentCustomer.setPasswordForSingleAuthenticationActive(true);
		modelService.save(currentCustomer);

	}

	@Override
	public boolean isSetUpPasswordForm() {
		final CustomerModel currentCustomer = (CustomerModel) userService.getCurrentUser();
		return !currentCustomer.isPasswordForSingleAuthenticationActive();
	}

	@Override
	public boolean isSetUpPasswordForm(String userId) {
		final CustomerModel currentCustomer = (CustomerModel) userService.getUserForUID(userId);
		return !currentCustomer.isPasswordForSingleAuthenticationActive();
	}

	@Override
	public void setPasswordForSingleAuthenticationActiveToCustomer(String id, boolean isActive) {
		final CustomerModel customer = (CustomerModel) userService.getUserForUID(id);
		customer.setPasswordForSingleAuthenticationActive(isActive);
		modelService.save(customer);
	}

	public void setUserService(UserService userService)	{
		this.userService = userService;
	}

	public void setModelService(ModelService modelService) {
		this.modelService = modelService;
	}

}
