/*

 */
package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.data.PayPalAddressDetailsData;
import com.paypal.hybris.facade.facades.PayPalAcceleratorCheckoutFacade;
import com.paypal.hybris.facade.facades.PayPalGuestCheckoutFacade;
import de.hybris.platform.commercefacades.customer.CustomerFacade;
import de.hybris.platform.commercefacades.order.OrderFacade;
import de.hybris.platform.commerceservices.customer.DuplicateUidException;
import de.hybris.platform.servicelayer.session.SessionService;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/**
 * This class is a default implementation of the PayPalGuestCheckoutFacade interface
 */
public class DefaultPayPalGuestCheckoutFacade implements PayPalGuestCheckoutFacade {

    private static final String ANONYMOUS_USER_UID = "anonymous";
    private static final String ANONYMOUS_CHECKOUT = "anonymous_checkout";
    private static final String ANONYMOUS_CHECKOUT_GUID = "anonymous_checkout_guid";
    private static final Logger LOG = Logger.getLogger(DefaultPayPalGuestCheckoutFacade.class);

    private CustomerFacade customerFacade;
    private PayPalAcceleratorCheckoutFacade checkoutFacade;
    private SessionService sessionService;
    private OrderFacade orderFacade;

    @Override
    public void processCheckoutForAnonymous(PayPalAddressDetailsData addressDetailsData) {
        try {
            if (ANONYMOUS_USER_UID.equals(checkoutFacade.getCurrentSessionUserUid())) {
                customerFacade.createGuestUserForAnonymousCheckout(addressDetailsData.getEmail(),
                    addressDetailsData.getFirstName());
            } else if (!addressDetailsData.getEmail()
                .equalsIgnoreCase(StringUtils.substringAfter(checkoutFacade.getCurrentSessionUserUid(), "|"))) {
                customerFacade.createGuestUserForAnonymousCheckout(addressDetailsData.getEmail(),
                    addressDetailsData.getFirstName());
                sessionService.setAttribute(ANONYMOUS_CHECKOUT_GUID,
                    StringUtils.substringBefore(checkoutFacade.getCurrentSessionUserUid(), "|"));
            }
            sessionService.setAttribute(ANONYMOUS_CHECKOUT, true);
        } catch (final DuplicateUidException e) {
            LOG.warn("Guest registration failed, PayPal email: " + addressDetailsData.getEmail() + ".\n details" + e);
        }
    }

    @Override
    public String getCostumerEmailByGuid(String guid) {
        return orderFacade.getOrderDetailsForGUID(guid).getUser().getUid();
    }

    public void setCustomerFacade(CustomerFacade customerFacade) {
        this.customerFacade = customerFacade;
    }

    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setCheckoutFacade(PayPalAcceleratorCheckoutFacade checkoutFacade) {
        this.checkoutFacade = checkoutFacade;
    }

    public void setOrderFacade(OrderFacade orderFacade) {
        this.orderFacade = orderFacade;
    }
}
