package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.service.PayPalCartService;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.facade.facades.PayPalFraudNetFacade;
import de.hybris.platform.commerceservices.util.GuidKeyGenerator;

import static com.paypal.hybris.facade.constants.PaypalfacadesConstants.FRAUDNET_MAX_LENGTH;


public class DefaultPayPalFraudNetFacade implements PayPalFraudNetFacade {

    private static final String MARK_PAGE_TYPE = "mark";
    private static final String BILLING_PAGE_TYPE = "billing";

    private GuidKeyGenerator guidKeyGenerator;
    private PayPalConfigurationService payPalConfigurationService;
    private PayPalCartService payPalCartService;

    @Override
    public String getCorrelationId() {
        final String correlationId = guidKeyGenerator.generate().toString();
        return cutStringToMaxLength(correlationId);
    }

    @Override
    public String getPageId(String pageType) {
        return payPalConfigurationService.getFraudNetId(MARK_PAGE_TYPE.equals(pageType) ? BILLING_PAGE_TYPE : pageType);
    }

    private static String cutStringToMaxLength(String str) {
        return new StringBuilder(str).delete(FRAUDNET_MAX_LENGTH, str.length()).toString();
    }

    @Override
    public void saveCorrelationId(String correlationId) {
        payPalCartService.saveCorrelationId(correlationId);
    }

    public void setGuidKeyGenerator(GuidKeyGenerator guidKeyGenerator) {
        this.guidKeyGenerator = guidKeyGenerator;
    }

    public void setPayPalConfigurationService(PayPalConfigurationService payPalConfigurationService) {
        this.payPalConfigurationService = payPalConfigurationService;
    }

    public void setPayPalCartService(PayPalCartService payPalCartService) {
        this.payPalCartService = payPalCartService;
    }
}
