package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.event.PayPalEmailNotificationEvent;
import com.paypal.hybris.facade.facades.PayPalConnectWithPayPalNotificationFacade;
import de.hybris.platform.servicelayer.event.EventService;

import static com.paypal.hybris.core.enums.PayPalEmailEvent.LINK;
import static com.paypal.hybris.core.enums.PayPalEmailEvent.UNLINK;

public class DefaultPayPalConnectWithPayPalNotificationFacade implements PayPalConnectWithPayPalNotificationFacade {

    private EventService eventService;

    @Override
    public void sendLinkCustomerEmailNotification(String uid) {
        eventService.publishEvent(new PayPalEmailNotificationEvent(uid, LINK));
    }

    @Override
    public void sendUnlinkCustomerEmailNotification(String uid) {
        eventService.publishEvent(new PayPalEmailNotificationEvent(uid, UNLINK));
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }
}
