package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.model.ApplePayConfigurationModel;
import com.paypal.hybris.core.model.ConnectWithPayPalConfigurationModel;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;
import com.paypal.hybris.core.model.LocalPaymentsConfigurationModel;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import com.paypal.hybris.core.model.PayPalGeneralConfigurationModel;
import com.paypal.hybris.core.model.VenmoConfigurationModel;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.ApplePayConfigurationData;
import com.paypal.hybris.data.ConnectWithPayPalConfigurationData;
import com.paypal.hybris.data.HostedFieldsConfigurationData;
import com.paypal.hybris.data.PayPalConfigurationData;
import com.paypal.hybris.data.PayPalFraudNetConfigurationData;
import com.paypal.hybris.data.PayPalEssentialConfigurationData;
import com.paypal.hybris.data.LocalPaymentsConfigurationData;
import com.paypal.hybris.data.PayPalGeneralConfigurationData;
import com.paypal.hybris.data.PayPalPluginConfigurationData;
import com.paypal.hybris.data.VenmoConfigurationData;
import com.paypal.hybris.facade.facades.PayPalConfigurationFacade;
import com.paypal.hybris.facade.facades.PayPalFraudNetFacade;
import de.hybris.platform.servicelayer.dto.converter.Converter;

import java.util.Locale;


public class DefaultPayPalConfigurationFacade implements PayPalConfigurationFacade {

    private PayPalConfigurationService payPalConfigurationService;
    private PayPalFraudNetFacade payPalFraudNetFacade;
    private Converter<PayPalGeneralConfigurationModel, PayPalGeneralConfigurationData> payPalGeneralConfigurationConverter;
    private Converter<PayPalConfigurationModel, PayPalConfigurationData> payPalConfigurationConverter;
    private Converter<VenmoConfigurationModel, VenmoConfigurationData> venmoConfigurationConverter;
    private Converter<LocalPaymentsConfigurationModel, LocalPaymentsConfigurationData> localPaymentsConfigurationConverter;
    private Converter<HostedFieldsConfigurationModel, HostedFieldsConfigurationData> hostedFieldsConfigurationConverter;
    private Converter<ConnectWithPayPalConfigurationModel, ConnectWithPayPalConfigurationData> connectWithPayPalConfigurationConverter;
    private Converter<ApplePayConfigurationModel, ApplePayConfigurationData> applePayConfigurationConverter;

    @Override
    public PayPalGeneralConfigurationData getPayPalGeneralConfigurationData() {
        return payPalGeneralConfigurationConverter.convert(payPalConfigurationService.getPayPalPluginConfiguration()
                .getPayPalGeneralConfiguration());
    }

    @Override
    public PayPalConfigurationData getPayPalConfigurationData() {
        PayPalConfigurationData payPalConfigurationData = payPalConfigurationConverter.convert(
                payPalConfigurationService.getPayPalPluginConfiguration().getPayPalConfiguration());
        payPalConfigurationData.setCommitEnable(payPalConfigurationService.isCommitEnabled());
        payPalConfigurationData.setIsReplenishmentAvailable(payPalConfigurationService.isReplenishmentAvailable());
        payPalConfigurationData.setSaveOrderFlow(payPalConfigurationService.isSaveOrderFlow());
        return payPalConfigurationData;

    }

    @Override
    public VenmoConfigurationData getVenmoConfigurationData() {
        return venmoConfigurationConverter.convert(
                payPalConfigurationService.getPayPalPluginConfiguration().getVenmoConfiguration());
    }

    @Override
    public HostedFieldsConfigurationData getHostedFieldsConfigurationData() {
        return hostedFieldsConfigurationConverter.convert(
                payPalConfigurationService.getPayPalPluginConfiguration().getHostedFieldsConfiguration());
    }

    @Override
    public ConnectWithPayPalConfigurationData getConnectWithPayPalConfigurationData() {
        return connectWithPayPalConfigurationConverter.convert(
                payPalConfigurationService.getPayPalPluginConfiguration().getConnectWithPayPalConfiguration());
    }

    @Override
    public ApplePayConfigurationData getApplePayConfigurationData() {
        return applePayConfigurationConverter.convert(
                payPalConfigurationService.getPayPalPluginConfiguration().getApplePayConfiguration()
        );
    }

    @Override
    public LocalPaymentsConfigurationData getLocalPaymentsConfigurationData() {
        return localPaymentsConfigurationConverter.convert(
                payPalConfigurationService.getPayPalPluginConfiguration().getLocalPaymentsConfiguration());
    }

    @Override
    public PayPalPluginConfigurationData getPayPalPluginConfigurationData() {
        return GenericBuilder.of(PayPalPluginConfigurationData::new)
                .with(PayPalPluginConfigurationData::setPayPalGeneralConfigurationData, getPayPalGeneralConfigurationData())
                .with(PayPalPluginConfigurationData::setPayPalConfigurationData, getPayPalConfigurationData())
                .with(PayPalPluginConfigurationData::setVenmoConfigurationData, getVenmoConfigurationData())
                .with(PayPalPluginConfigurationData::setHostedFieldsConfigurationData, getHostedFieldsConfigurationData())
                .with(PayPalPluginConfigurationData::setConnectWithPayPalConfigurationData, getConnectWithPayPalConfigurationData())
                .with(PayPalPluginConfigurationData::setApplePayConfigurationData, getApplePayConfigurationData())
                .with(PayPalPluginConfigurationData::setLocalPaymentsConfigurationData, getLocalPaymentsConfigurationData())
                .build();
    }


    @Override
    public PayPalEssentialConfigurationData getPayPalEssentialConfigurationData() {
        return GenericBuilder.of(PayPalEssentialConfigurationData::new)
                .with(PayPalEssentialConfigurationData::setClientId, payPalConfigurationService.getClientID())
                .with(PayPalEssentialConfigurationData::setPayPalSdkJsUrl, payPalConfigurationService.getPayPalSdkJsUrl())
                .with(PayPalEssentialConfigurationData::setPayPalPartnerAttributionId, payPalConfigurationService.getPayPalPartnerAttributionId())
                .with(PayPalEssentialConfigurationData::setEnvironmentType, payPalConfigurationService.getEnvironmentType())
                .with(PayPalEssentialConfigurationData::setNonDecimalCurrency, payPalConfigurationService.getNonDecimalCurrency())
                .build();
    }

    @Override
    public PayPalFraudNetConfigurationData getPayPalFraudNetConfigurationData(String pageType) {
        PayPalFraudNetConfigurationData fraudNetConfigurationData = new PayPalFraudNetConfigurationData();
        String correlationId = payPalFraudNetFacade.getCorrelationId();
        payPalFraudNetFacade.saveCorrelationId(correlationId);
        fraudNetConfigurationData.setCorrelationId(correlationId);
        fraudNetConfigurationData.setPageId(payPalFraudNetFacade.getPageId(pageType.toLowerCase(Locale.US)));
        return fraudNetConfigurationData;
    }

    public void setPayPalConfigurationService(PayPalConfigurationService payPalConfigurationService) {
        this.payPalConfigurationService = payPalConfigurationService;
    }

    public void setPayPalGeneralConfigurationConverter(Converter<PayPalGeneralConfigurationModel, PayPalGeneralConfigurationData> payPalGeneralConfigurationConverter) {
        this.payPalGeneralConfigurationConverter = payPalGeneralConfigurationConverter;
    }

    public void setPayPalConfigurationConverter(Converter<PayPalConfigurationModel, PayPalConfigurationData> payPalConfigurationConverter) {
        this.payPalConfigurationConverter = payPalConfigurationConverter;
    }

    public void setVenmoConfigurationConverter(Converter<VenmoConfigurationModel, VenmoConfigurationData> venmoConfigurationConverter) {
        this.venmoConfigurationConverter = venmoConfigurationConverter;
    }

    public void setHostedFieldsConfigurationConverter(Converter<HostedFieldsConfigurationModel, HostedFieldsConfigurationData> hostedFieldsConfigurationConverter) {
        this.hostedFieldsConfigurationConverter = hostedFieldsConfigurationConverter;
    }

    public void setConnectWithPayPalConfigurationConverter(Converter<ConnectWithPayPalConfigurationModel, ConnectWithPayPalConfigurationData> connectWithPayPalConfigurationConverter) {
        this.connectWithPayPalConfigurationConverter = connectWithPayPalConfigurationConverter;
    }

    public void setApplePayConfigurationConverter(Converter<ApplePayConfigurationModel, ApplePayConfigurationData> applePayConfigurationConverter) {
        this.applePayConfigurationConverter = applePayConfigurationConverter;
    }

    public void setPayPalFraudNetFacade(PayPalFraudNetFacade payPalFraudNetFacade) {
        this.payPalFraudNetFacade = payPalFraudNetFacade;
    }

    public void setLocalPaymentsConfigurationConverter(Converter<LocalPaymentsConfigurationModel, LocalPaymentsConfigurationData> localPaymentsConfigurationConverter) {
        this.localPaymentsConfigurationConverter = localPaymentsConfigurationConverter;
    }
}
