package com.paypal.hybris.facade.facades;

import com.paypal.hybris.data.PayPalConnectAddressData;
import com.paypal.hybris.data.PayPalConnectUserData;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.core.model.user.CustomerModel;

import java.util.Date;


public interface PayPalCustomerFacade {

    boolean isPayPalAddressPresent(String email, PayPalConnectAddressData payPalAddressData);

    boolean isPayPalPaymentMethodPresent(String email, PayPalConnectUserData userData);

    boolean isPayerIdInCustomer(String uid);

    boolean isUserDisabled(Date deactivationDate);

    void unlinkLoginWithPayPal();

    boolean addShippingAddressToCurrentUser(AddressData newBillingAddress);

    boolean isDuplicateAddressForCustomer(final AddressData addressData, final CustomerModel customerModel);
}
