package com.paypal.hybris.facade.facades;


import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.data.ApplePayAddressDetailsData;
import com.paypal.hybris.data.ApplePayLineItem;
import com.paypal.hybris.data.ApplePaySessionDetailsData;
import com.paypal.hybris.data.AuthenticationResultData;
import com.paypal.hybris.data.PayPalCheckoutData;
import com.paypal.hybris.data.PayPalConnectAddressData;
import com.paypal.hybris.data.PayPalCreateOrderData;
import com.paypal.hybris.data.PayPalOrderDetailsData;
import com.paypal.hybris.data.PayPalSetupTokenResponse;
import de.hybris.platform.acceleratorfacades.order.AcceleratorCheckoutFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.order.data.OrderData;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.core.enums.CreditCardType;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.order.InvalidCartException;

import java.util.List;


public interface PayPalAcceleratorCheckoutFacade extends AcceleratorCheckoutFacade {

    boolean processExpressCheckout(final PayPalOrderDetailsData orderDetailsData, String paymentMethodType);

    CCPaymentInfoData createPayPalPaymentSubscriptionForExpressCheckout(final PayPalOrderDetailsData orderDetailsData,
        String paymentMethodType);

    CCPaymentInfoData createPayPalPaymentSubscriptionForMarkCheckout(final String orderId, CreditCardType paymentType, String cardHolderName, boolean isShouldBeSaved);

    void addAddressForNewUser(final PayPalConnectAddressData addressData, final String payerId);

    CCPaymentInfoData updatePayPalPaymentSubscription(PayPalOrderDetailsData orderDetailsData,
        CCPaymentInfoData paymentInfoData);

    PayPalOrderDetailsData getPayPalOrderDetails(final String orderId);

    PayPalOrderDetailsData getPayPalOrderDetails();

    boolean isThreeDsVerificationSuccess(final AuthenticationResultData authenticationResultData);

    String getCurrentSessionUserUid();

    String createPayPalOrder(PayPalCreateOrderData createOrderData);

    boolean isPayPalAddressValid(final AddressData addressData);

    String createPayPalOrderForExpressCheckout();

    String createApplePayOrderForExpressCheckout(ApplePayAddressDetailsData applePayShippingAddress);

    void updateCheckoutPaymentInfoOrderId(final String orderId);

    boolean setSelectedPaymentInfoToCart(final String paymentDetails);

    void setDeliveryAddressForCheckout(AddressData addressData);

    boolean isPickupInStore();

    boolean isLocalPaymentFlow();

    boolean authorizePayment(final CartModel cartModel);

    void prepareCartForCheckout(final CartModel cartModel);

    OrderData placeOrderByCart(final CartModel cartModel) throws InvalidCartException;

    PayPalCheckoutData getPayPalCheckoutData(final String pageType);

    CreditCardType setCreditCardType(final String fundingSource);

    List<CCPaymentInfoData> getCCPaymentInfos(boolean saved, CustomerModel currentCustomer);

    List<CCPaymentInfoData> getAvailableCCPaymentInfosForCurrentUser();

    CCPaymentInfoData getCCPaymentInfoByOrderId(final String payPayOrderId);

    PayPalCreditCardPaymentInfoModel createPayPalPaymentSubscription(final PayPalSetupTokenResponse payPalSetupTokenResponse,
                                                                     boolean savePaymentInfo,
                                                                     PayPalCreditCardPaymentInfoModel dumbPaymentInfo,
                                                                     CustomerModel customerModel);

    List<ApplePayLineItem> getApplePayLineItemsFromCart();

    void updateApplePayShippingAddress(ApplePayAddressDetailsData applePayAddressDetailsData);

    ApplePaySessionDetailsData createApplePaySessionDetails(String flow);

}
