package com.paypal.hybris.facade.context;

import de.hybris.platform.acceleratorservices.model.cms2.pages.EmailPageModel;
import de.hybris.platform.acceleratorservices.process.email.context.AbstractEmailContext;
import de.hybris.platform.basecommerce.model.site.BaseSiteModel;
import de.hybris.platform.commerceservices.model.process.StoreFrontCustomerProcessModel;
import de.hybris.platform.core.model.c2l.LanguageModel;
import de.hybris.platform.core.model.user.CustomerModel;


public class PayPalEmailContext extends AbstractEmailContext<StoreFrontCustomerProcessModel> {

    public void init(final StoreFrontCustomerProcessModel processModel, final EmailPageModel emailPageModel) {
        super.init(processModel, emailPageModel);
        if (get(DISPLAY_NAME) == null) {
            put(DISPLAY_NAME, processModel.getCustomer().getName());
        }
    }

    @Override
    protected BaseSiteModel getSite(StoreFrontCustomerProcessModel businessProcessModel) {
        return businessProcessModel.getSite();
    }

    @Override
    protected CustomerModel getCustomer(StoreFrontCustomerProcessModel businessProcessModel) {
        return businessProcessModel.getCustomer();
    }

    @Override
    protected LanguageModel getEmailLanguage(StoreFrontCustomerProcessModel businessProcessModel) {
        return businessProcessModel.getLanguage();
    }

}
