package com.paypal.hybris.facade.builders;

import com.paypal.hybris.addon.forms.PaymentTokenData;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.PayPalPaymentInfoService;
import de.hybris.platform.core.model.user.CustomerModel;

import java.util.Optional;


public class TokenRequestDirector {

    private PayPalPaymentInfoService payPalPaymentInfoService;

    public void constructGetPaymentTokenRequest(PaypalGetPaymentTokenRequestBuilder builder,
                                                PaymentTokenData paymentTokenData) {
        builder.setSetupTokenId(paymentTokenData.getSetupToken());
        setCustomerId(paymentTokenData, builder);
    }

    private void setCustomerId(PaymentTokenData paymentTokenData, PaypalTokenRequestBuilder builder) {
        Optional<PayPalCreditCardPaymentInfoModel> paymentInfoModel = payPalPaymentInfoService.getPaymentInfoByPK(paymentTokenData.getPaymentInfoPK());
        if (paymentInfoModel.isEmpty()) {
            throw new IllegalArgumentException("Could not find payment info by PK");
        }
        CustomerModel customerModel = (CustomerModel) paymentInfoModel.get().getUser();
        builder.setCustomerId(customerModel.getVaultCustomerId());
    }

    public void setPayPalPaymentInfoService(PayPalPaymentInfoService payPalPaymentInfoService) {
        this.payPalPaymentInfoService = payPalPaymentInfoService;
    }

}
