package com.paypal.hybris.facade.builders;

import com.paypal.hybris.data.PayPalCustomerData;
import com.paypal.hybris.data.PayPalPaymentSource;
import com.paypal.hybris.data.PayPalSavePaymentForPurchaseLaterRequest;
import com.paypal.hybris.data.PayPalTokenData;

public class PaypalGetPaymentTokenRequestBuilder implements PaypalTokenRequestBuilder {

    private static final String SETUP_TOKEN = "SETUP_TOKEN";
    private String setupTokenId;
    private String customerId;

    public PayPalSavePaymentForPurchaseLaterRequest getResult() {
        final PayPalSavePaymentForPurchaseLaterRequest request = new PayPalSavePaymentForPurchaseLaterRequest();
        final PayPalPaymentSource paymentSource = new PayPalPaymentSource();

        final PayPalTokenData tokenData = new PayPalTokenData();
        tokenData.setId(this.setupTokenId);
        tokenData.setType(SETUP_TOKEN);
        paymentSource.setToken(tokenData);

        final PayPalCustomerData customerData = new PayPalCustomerData();
        customerData.setId(this.customerId);
        request.setCustomer(customerData);

        request.setPaymentSource(paymentSource);

        return request;
    }

    public void setSetupTokenId(String setupTokenId) {
        this.setupTokenId = setupTokenId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

}
