/**
 *
 */
package com.paypal.hybris.core.validator;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.c2l.CountryModel;
import de.hybris.platform.core.model.c2l.RegionModel;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class PayPalAddressDetailValidatorTest {

    private static final String COUNTY_ISO_CODE_TEST = "UA";
    private static final String COUNTY_ISO_CODE_WRONG_TEST = "WR";
    private static final String REGION_ISO_CODE_TEST = "ZA";
    private static final String COUNTRY_REGION_ISO_CODE_TEST = "UA-ZA";
    private static final String COUNTRY_REGION_ISO_CODE_WRONG_TEST = "WR-ONG";

    @Mock
    private CommonI18NService commonI18NService;

    @Mock
    private RegionModel regionModel;

    @Mock
    private RegionModel regionModel2;

    @Mock
    private CountryModel countryModel;

    @Mock
    private CountryModel countryModel2;

    @InjectMocks
    private PayPalAddressDetailValidator unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void validatePayPalCountryCodeWithEmptyCodeShouldReturnFalse() {
        Assert.assertFalse(unit.validatePayPalCountryCode(""));
    }

    @Test
    public void validatePayPalCountryCodeWithExistingCountryCode() {
        when(countryModel.getIsocode()).thenReturn(COUNTY_ISO_CODE_TEST);
        when(countryModel2.getIsocode()).thenReturn(COUNTY_ISO_CODE_WRONG_TEST);
        List<CountryModel> countryModels = List.of(countryModel2, countryModel);
        when(commonI18NService.getAllCountries()).thenReturn(countryModels);

        Assert.assertTrue(unit.validatePayPalCountryCode(COUNTY_ISO_CODE_TEST));
        verify(commonI18NService).getAllCountries();
    }

    @Test
    public void validatePayPalRegionCodeWithEmptyCodeShouldReturnFalse() {
        Assert.assertFalse(unit.validatePayPalRegionCode("", ""));
    }

    @Test
    public void validatePayPalRegionCodeWithExistingRegionShouldReturnTrue() {
        List<RegionModel> regionModels = List.of(regionModel2, regionModel);

        when(regionModel.getIsocode()).thenReturn(COUNTRY_REGION_ISO_CODE_TEST);
        when(regionModel2.getIsocode()).thenReturn(COUNTRY_REGION_ISO_CODE_WRONG_TEST);
        when(commonI18NService.getAllRegions()).thenReturn(regionModels);

        Assert.assertTrue(unit.validatePayPalRegionCode(COUNTY_ISO_CODE_TEST, REGION_ISO_CODE_TEST));
        verify(commonI18NService).getAllRegions();
    }
}

