package com.paypal.hybris.core.util;

import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;

import java.time.YearMonth;

import static org.junit.Assert.assertEquals;

@UnitTest
public class ExpiredDateValidatorUtilTest {

    private ExpiredDateValidatorUtil unit;

    @Before
    public void setUp() throws Exception {
        unit = new ExpiredDateValidatorUtil();
    }

    @Test
    public void shouldGetMonthsToExpiration() {
        long expected = 1;

        YearMonth yearMonth = YearMonth.now();

        int month = yearMonth.getMonth().getValue() + 1;
        String formattedMonth = month < 10 ? "0" + month : String.valueOf(month);
        String year = String.valueOf(yearMonth.getYear());

        assertEquals(expected, unit.getMonthsToExpiration(formattedMonth, year));
    }
}