package com.paypal.hybris.core.strategy.storedcredential.impl;

import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.StoredCredentialData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.REPLENISHMENT;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.DISABLE;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.MERCHANT;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.RECURRING;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.SUBSEQUENT;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class ReplenishmentStoredCredentialStrategyTest {

    @Mock
    private PayPalConfigurationService payPalConfigurationService;

    @InjectMocks
    private ReplenishmentStoredCredentialStrategy unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetStoredCredential() {
        StoredCredentialData expectedStoredCredentialData = GenericBuilder.of(StoredCredentialData::new)
                .with(StoredCredentialData::setPaymentInitiator, MERCHANT)
                .with(StoredCredentialData::setPaymentType, RECURRING)
                .with(StoredCredentialData::setUsage, SUBSEQUENT)
                .build();

        StoredCredentialData actualStoredCredentialData = unit.getStoredCredential();

        assertEquals(expectedStoredCredentialData.getPaymentInitiator(), actualStoredCredentialData.getPaymentInitiator());
        assertEquals(expectedStoredCredentialData.getPaymentType(), actualStoredCredentialData.getPaymentType());
        assertEquals(expectedStoredCredentialData.getUsage(), actualStoredCredentialData.getUsage());
    }

    @Test
    public void shouldExecuteReplenishmentStoredCredentialStrategyTestMethodAndReturnTrue() {
        when(payPalConfigurationService.getPayPal3DSVerificationType()).thenReturn(SUBSEQUENT);

        assertTrue(unit.test(REPLENISHMENT));
    }

    @Test
    public void shouldExecuteReplenishmentStoredCredentialStrategyTestMethodAndReturnFalse() {
        when(payPalConfigurationService.getPayPal3DSVerificationType()).thenReturn(DISABLE);

        assertFalse(unit.test(REPLENISHMENT));
    }
}