package com.paypal.hybris.core.strategy.storedcredential.impl;

import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.StoredCredentialData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.ONE_TIME_PAYMENT;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_CAPTURE;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.CUSTOMER;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.DERIVED;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.DISABLE;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.ONE_TIME;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class IntentCaptureOneTimePaymentStrategyTest {

    @Mock
    private PayPalConfigurationService payPalConfigurationService;

    @InjectMocks
    private IntentCaptureOneTimePaymentStrategy unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetStoredCredential() {
        StoredCredentialData expectedStoredCredentialData = GenericBuilder.of(StoredCredentialData::new)
                .with(StoredCredentialData::setPaymentInitiator, CUSTOMER)
                .with(StoredCredentialData::setPaymentType, ONE_TIME)
                .with(StoredCredentialData::setUsage, DERIVED)
                .build();

        StoredCredentialData actualStoredCredentialData = unit.getStoredCredential();

        assertEquals(expectedStoredCredentialData.getPaymentInitiator(), actualStoredCredentialData.getPaymentInitiator());
        assertEquals(expectedStoredCredentialData.getPaymentType(), actualStoredCredentialData.getPaymentType());
        assertEquals(expectedStoredCredentialData.getUsage(), actualStoredCredentialData.getUsage());
    }

    @Test
    public void shouldExecuteIntentCaptureOneTimePaymentStrategyTestMethodAndReturnTrue() {
        when(payPalConfigurationService.getPayPalIntent()).thenReturn(PAYPAL_INTENT_CAPTURE);
        when(payPalConfigurationService.getPayPal3DSVerificationType()).thenReturn(DERIVED);

        assertTrue(unit.test(ONE_TIME_PAYMENT));
    }

    @Test
    public void shouldExecuteIntentCaptureOneTimePaymentStrategyTestMethodAndReturnFalse() {
        when(payPalConfigurationService.getPayPalIntent()).thenReturn(PAYPAL_INTENT_CAPTURE);
        when(payPalConfigurationService.getPayPal3DSVerificationType()).thenReturn(DISABLE);

        assertFalse(unit.test(ONE_TIME_PAYMENT));
    }
}