package com.paypal.hybris.core.strategy.storedcredential.impl;

import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.StoredCredentialData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_AUTHORIZE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.SAVED_PAYMENT;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.CUSTOMER;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.DISABLE;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.SUBSEQUENT;
import static com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy.UNSCHEDULED;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class IntentAuthorizeSavedPaymentStrategyTest {

    @Mock
    private PayPalConfigurationService payPalConfigurationService;

    @InjectMocks
    private IntentAuthorizeSavedPaymentStrategy unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetStoredCredential() {
        StoredCredentialData expectedStoredCredentialData = GenericBuilder.of(StoredCredentialData::new)
                .with(StoredCredentialData::setPaymentInitiator, CUSTOMER)
                .with(StoredCredentialData::setPaymentType, UNSCHEDULED)
                .with(StoredCredentialData::setUsage, SUBSEQUENT)
                .build();

        StoredCredentialData actualStoredCredentialData = unit.getStoredCredential();

        assertEquals(expectedStoredCredentialData.getPaymentInitiator(), actualStoredCredentialData.getPaymentInitiator());
        assertEquals(expectedStoredCredentialData.getPaymentType(), actualStoredCredentialData.getPaymentType());
        assertEquals(expectedStoredCredentialData.getUsage(), actualStoredCredentialData.getUsage());

    }

    @Test
    public void shouldExecuteIntentAuthorizeSavedPaymentStrategyTestMethodAndReturnTrue() {
        when(payPalConfigurationService.getPayPalIntent()).thenReturn(PAYPAL_INTENT_AUTHORIZE);
        when(payPalConfigurationService.getPayPal3DSVerificationType()).thenReturn(SUBSEQUENT);

        assertTrue(unit.test(SAVED_PAYMENT));
    }

    @Test
    public void shouldExecuteIntentAuthorizeSavedPaymentStrategyTestMethodAndReturnFalse() {
        when(payPalConfigurationService.getPayPalIntent()).thenReturn(PAYPAL_INTENT_AUTHORIZE);
        when(payPalConfigurationService.getPayPal3DSVerificationType()).thenReturn(DISABLE);

        assertFalse(unit.test(SAVED_PAYMENT));
    }
}