package com.paypal.hybris.core.strategy.storedcredential.impl;

import com.paypal.hybris.core.service.PayPalConfigurationService;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class EmptyStoredCredentialStrategyTest {


    private static final String DISABLE = "DISABLE";
    private static final String STRING = "string";

    @Mock
    private PayPalConfigurationService payPalConfigurationService;

    @InjectMocks
    private EmptyStoredCredentialStrategy unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetEmptyStoredCredential() {
        assertNull(unit.getStoredCredential());
    }

    @Test
    public void shouldExecuteEmptyStoredCredentialStrategyTestMethod() {
        when(payPalConfigurationService.getPayPal3DSVerificationType()).thenReturn(DISABLE);

        assertTrue(unit.test(STRING));
    }
}