package com.paypal.hybris.core.strategy;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.strategy.impl.DefaultPayPalCommercePaymentProviderStrategy;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.order.CartService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import static org.mockito.Mockito.verify;

@UnitTest
public class DefaultPayPalCommercePaymentProviderStrategyTest {

    private static final String PAYPAL_PROVIDER_NAME = "PayPal";

    @Mock
    private CartService cartService;

    @InjectMocks
    private DefaultPayPalCommercePaymentProviderStrategy unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void getPaymentProviderTest() {
        final CartModel cartModel = mock(CartModel.class);
        final PayPalCreditCardPaymentInfoModel paymentInfoModel = mock(PayPalCreditCardPaymentInfoModel.class);

        when(cartService.getSessionCart()).thenReturn(cartModel);
        when(cartModel.getPaymentInfo()).thenReturn(paymentInfoModel);

        String paymentProvider = unit.getPaymentProvider();

        assertEquals(PAYPAL_PROVIDER_NAME, paymentProvider);
        verify(cartService).getSessionCart();
    }

    @Test
    public void getPaymentProviderWithCartModelParameterTest() {
        final CartModel cartModel = mock(CartModel.class);
        final PayPalCreditCardPaymentInfoModel paymentInfoModel = mock(PayPalCreditCardPaymentInfoModel.class);

        when(cartModel.getPaymentInfo()).thenReturn(paymentInfoModel);

        String paymentProvider = unit.getPaymentProvider(cartModel);

        assertEquals(PAYPAL_PROVIDER_NAME, paymentProvider);
    }
}
