package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.dao.PayPalLogoDao;
import com.paypal.hybris.core.service.impl.DefaultPaypalLogoService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.catalog.model.CatalogUnawareMediaModel;
import de.hybris.platform.servicelayer.media.MediaService;
import de.hybris.platform.servicelayer.model.ModelService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Optional;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPaypalLogoServiceTest {

    private static final String LOGO_CODE = "logoCode";

    @Mock
    private MediaService mediaService;
    @Mock
    private ModelService modelService;
    @Mock
    private PayPalLogoDao payPalLogoDao;
    @Mock
    private CatalogUnawareMediaModel mediaModel;

    @InjectMocks
    private DefaultPaypalLogoService unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetHybrisLogoUrl() {
        when(mediaService.getMedia(LOGO_CODE)).thenReturn(mediaModel);

        unit.getHybrisLogoUrl(LOGO_CODE);

        verify(mediaService).getMedia(LOGO_CODE);
        verify(mediaModel).getURL();
    }

    @Test
    public void createLogo() {
        when(payPalLogoDao.findExistingLogo(LOGO_CODE)).thenReturn(Optional.of(mediaModel));
        doNothing().when(modelService).save(mediaModel);
        doNothing().when(mediaService).setStreamForMedia(any(), any());

        unit.createLogo(LOGO_CODE);

        verify(modelService).save(mediaModel);
        verify(mediaService).setStreamForMedia(any(), any());
    }

}