package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.dao.PaypalAccessTokenDao;
import com.paypal.hybris.core.model.PaypalAccessTokenModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commerceservices.util.GuidKeyGenerator;
import de.hybris.platform.servicelayer.model.ModelService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

import java.util.Optional;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.any;

@UnitTest
public class DefaultPaypalAccessTokenServiceTest {

    private static final String GUID = "GUID";
    private static final String ACCESS_TOKEN = "accessToken";

    @Mock
    private PaypalAccessTokenDao paypalAccessTokenDao;

    @Mock
    private GuidKeyGenerator guidKeyGenerator;

    @Mock
    private ModelService modelService;

    @Mock
    private PaypalAccessTokenModel accessTokenModel;

    @Spy
    @InjectMocks
    private DefaultPaypalAccessTokenService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetPaypalAccessToken() {
        when(paypalAccessTokenDao.findAccessTokenByGuid(GUID)).thenReturn(Optional.of(accessTokenModel));

        Optional<PaypalAccessTokenModel> result = unit.getPaypalAccessToken(GUID);

        assertEquals(accessTokenModel, result.get());
        verify(paypalAccessTokenDao).findAccessTokenByGuid(GUID);
    }

    @Test
    public void shouldSavePaypalAccessToken() {
        when(guidKeyGenerator.generate()).thenReturn(GUID);
        doNothing().when(modelService).save(any(PaypalAccessTokenModel.class));

        String result = unit.savePaypalAccessToken(ACCESS_TOKEN);

        assertEquals(GUID, result);
        verify(guidKeyGenerator).generate();
        verify(modelService).save(any(PaypalAccessTokenModel.class));
    }

    @Test
    public void shouldRemovePaypalAccessToken() {
        Optional<PaypalAccessTokenModel> optionalAccessTokenModel = Optional.of(accessTokenModel);

        doReturn(optionalAccessTokenModel).when(unit).getPaypalAccessToken(GUID);
        doNothing().when(modelService).remove(accessTokenModel);

        unit.removePaypalAccessToken(GUID);

        verify(unit).getPaypalAccessToken(GUID);
        verify(modelService).remove(accessTokenModel);
    }
}
