/**
 *
 */
package com.paypal.hybris.core.service.impl;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.paypal.hybris.core.results.PayPalCaptureResult;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.c2l.CurrencyModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.payment.commands.result.CaptureResult;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.dto.TransactionStatusDetails;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.payment.methods.CardPaymentService;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import de.hybris.platform.servicelayer.i18n.I18NService;
import de.hybris.platform.servicelayer.model.ModelService;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Date;

import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalManualMultiCaptureServiceTest {

    private static final String CURRENCY_ISO_CODE = "USD";
    private static final String USD = "USD";

    @Mock
    private ModelService modelService;

    @Mock
    private I18NService i18nService;

    @Mock
    private PayPalCaptureResult captureResult;

    @Mock
    private Currency currency;

    @Mock
    private PaymentTransactionEntryModel paymentTransactionEntryModel;

    @Mock
    private PaymentTransactionModel paymentTransactionModel;

    @Mock
    private CurrencyModel currencyModel;

    @Mock
    private OrderModel orderModel;

    @Mock
    private CardPaymentService cardPaymentService;

    @InjectMocks
    private DefaultPayPalManualMultiCaptureService unit;

    private Date date;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        date = new Date();
    }

    @Test
    public void doMultiCaptureWithCorrectDataShouldNotTrowExceptions() {
        final BigDecimal amount = BigDecimal.TEN;

        when(captureResult.getTransactionStatus()).thenReturn(TransactionStatus.ACCEPTED);
        when(captureResult.getTransactionStatusDetails()).thenReturn(TransactionStatusDetails.SUCCESFULL);
        when(cardPaymentService.capture(any())).thenReturn(captureResult);

        when(currencyModel.getIsocode()).thenReturn(CURRENCY_ISO_CODE);
        when(captureResult.getCurrency()).thenReturn(currency);
        when(captureResult.getRequestTime()).thenReturn(date);
        when(currency.getCurrencyCode()).thenReturn(USD);
        when(i18nService.getCurrency(USD)).thenReturn(currencyModel);

        when(paymentTransactionEntryModel.getPaymentTransaction()).thenReturn(paymentTransactionModel);
        when(paymentTransactionEntryModel.getCurrency()).thenReturn(currencyModel);
        when(paymentTransactionModel.getOrder()).thenReturn(orderModel);

        when(paymentTransactionModel.getEntries()).thenReturn(null);

        unit.doMultiCapture(amount, paymentTransactionEntryModel, PaymentTransactionType.CAPTURE);
        verify(captureResult).getTransactionStatus();
        verify(captureResult).getTransactionStatusDetails();
    }

    @Test
    public void doMultiCaptureWithCorrectDataShouldNotTrowExceptionsWhenPaymentTransactionTypePartialCapture() {
        final BigDecimal amount = BigDecimal.TEN;

        when(captureResult.getTransactionStatus()).thenReturn(TransactionStatus.ACCEPTED);
        when(captureResult.getTransactionStatusDetails()).thenReturn(TransactionStatusDetails.SUCCESFULL);
        when(cardPaymentService.capture(any())).thenReturn(captureResult);

        when(currencyModel.getIsocode()).thenReturn(CURRENCY_ISO_CODE);
        when(captureResult.getCurrency()).thenReturn(currency);
        when(captureResult.getRequestTime()).thenReturn(date);
        when(currency.getCurrencyCode()).thenReturn(USD);
        when(i18nService.getCurrency(USD)).thenReturn(currencyModel);

        when(paymentTransactionEntryModel.getPaymentTransaction()).thenReturn(paymentTransactionModel);
        when(paymentTransactionEntryModel.getCurrency()).thenReturn(currencyModel);
        when(paymentTransactionModel.getOrder()).thenReturn(orderModel);

        when(paymentTransactionModel.getEntries()).thenReturn(null);

        unit.doMultiCapture(amount, paymentTransactionEntryModel, PaymentTransactionType.PARTIAL_CAPTURE);
        verify(captureResult).getTransactionStatus();
        verify(captureResult).getTransactionStatusDetails();
    }

    @Test
    public void doMultiCaptureWithCorrectDataWhenCurrencyAndRequestedTimeNull() {
        final BigDecimal amount = BigDecimal.TEN;

        when(captureResult.getTransactionStatus()).thenReturn(TransactionStatus.ACCEPTED);
        when(captureResult.getTransactionStatusDetails()).thenReturn(TransactionStatusDetails.SUCCESFULL);
        when(cardPaymentService.capture(any())).thenReturn(captureResult);

        when(currencyModel.getIsocode()).thenReturn(CURRENCY_ISO_CODE);
        when(captureResult.getCurrency()).thenReturn(null);
        when(captureResult.getRequestTime()).thenReturn(null);

        when(paymentTransactionEntryModel.getPaymentTransaction()).thenReturn(paymentTransactionModel);
        when(paymentTransactionEntryModel.getCurrency()).thenReturn(currencyModel);
        when(paymentTransactionModel.getOrder()).thenReturn(orderModel);

        when(paymentTransactionModel.getEntries()).thenReturn(null);

        unit.doMultiCapture(amount, paymentTransactionEntryModel, PaymentTransactionType.CAPTURE);
        verify(captureResult).getTransactionStatus();
        verify(captureResult).getTransactionStatusDetails();
    }
}

