/**
 *
 */
package com.paypal.hybris.core.service.impl;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.CLIENT_ID;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_API_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_CHECKOUT_RETURN_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_RESPONSE_TYPE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_RETURN_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_SCOPES;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_SCRIPT;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ENV_CONFIGURATION;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_AUTHORIZE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_CAPTURE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_NONDECIMAL_CURRENCY;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_PARTNER_ATTRIBUTION_ID;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_SDK_JS_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.SECRET_KEY;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

import com.paypal.hybris.core.enums.SavedPaymentMethodsLimit;
import com.paypal.hybris.core.enums.ThreeDsVerificationOnMyAccountType;
import com.paypal.hybris.core.enums.ThreeDsVerificationType;
import com.paypal.hybris.core.exception.PayPalPluginConfigurationNotFound;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import com.paypal.hybris.core.model.PayPalGeneralConfigurationModel;
import com.paypal.hybris.core.model.PayPalPluginConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.config.ConfigurationService;
import de.hybris.platform.store.BaseStoreModel;
import de.hybris.platform.store.services.BaseStoreService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalConfigurationServiceTest {

    private static final String TEST_CLIENT_ID = "testClientId";
    private static final String TEST_PAY_PAL_PARTNER_ATTRIBUTION = "testPayPalPartnerAttribution";
    private static final String TEST_FRAUD_NET_ID = "testFraudNetId";
    private static final String CART = "cart";
    private static final String PAYPAL_FRAUDNET_CART_ID = "paypal.fraudnet.cart.id";
    private static final String TEST_SECRET_KEY = "testSecretKey";
    private static final String TEST_ENV_TYPE = "testEnvType";
    private static final String TEST_API_URL = "testApiUrl";
    private static final String TEST_SDK_JS_URL = "testSdkJsUrl";
    private static final String TEST_NON_DECIMAL_CURRENCY = "testNonDecimalCurrency";
    private static final String TEST_CONNECT_SCRIPT = "testConnectScript";
    private static final String TEST_CONNECT_SCOPES = "testConnectScopes";
    private static final String TEST_CONNECT_RESPONSE_TYPE = "testConnectResponseType";
    private static final String TEST_RETURN_URL = "testReturnUrl";
    private static final String TEST_BUYER_COUNTRY = "testBuyerCountry";
    private static final String TEST_LOCALE = "testLocale";

    @Mock(answer = Answers.RETURNS_DEEP_STUBS)
    private PayPalPluginConfigurationModel payPalPluginConfigurationModel;

    @Mock(answer = Answers.RETURNS_DEEP_STUBS)
    private ConfigurationService configurationService;

    @Mock
    private BaseStoreService baseStoreService;

    @Mock
    private BaseStoreModel baseStore;
    @Mock
    private PayPalConfigurationModel configurationModel;
    @Mock
    private PayPalGeneralConfigurationModel generalConfigurationModel;

    @InjectMocks
    private DefaultPayPalConfigurationService unit;


    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        when(baseStoreService.getCurrentBaseStore()).thenReturn(baseStore);
        when(baseStore.getPayPalPluginConfiguration()).thenReturn(payPalPluginConfigurationModel);
    }

    @Test
    public void shouldReturnTrueWhenExpressCheckoutEnabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isExpressCheckoutEnable()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isExpressCheckoutEnabled());
    }

    @Test
    public void shouldReturnFalseWhenExpressCheckoutDisabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isExpressCheckoutEnable()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isExpressCheckoutEnabled());
    }

    @Test
    public void shouldReturnTrueForSaveOrderFlowWhenVaultIsNotEnabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration()).thenReturn(configurationModel);
        when(configurationModel.isSaveOrderFlow()).thenReturn(Boolean.TRUE);
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration()).thenReturn(generalConfigurationModel);
        when(generalConfigurationModel.isSettleImmediately()).thenReturn(Boolean.FALSE);
        when(configurationModel.isVaultEnabled()).thenReturn(Boolean.FALSE);

        assertTrue(unit.isSaveOrderFlow());
    }

    @Test
    public void shouldReturnFalseForSaveOrderFlowWhenVaultIsEnabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration()).thenReturn(configurationModel);
        when(configurationModel.isSaveOrderFlow()).thenReturn(Boolean.TRUE);
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration()).thenReturn(generalConfigurationModel);
        when(generalConfigurationModel.isSettleImmediately()).thenReturn(Boolean.FALSE);
        when(configurationModel.isVaultEnabled()).thenReturn(Boolean.TRUE);

        assertFalse(unit.isSaveOrderFlow());
    }

    @Test
    public void shouldReturnTrueWhenCommitEnabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isSettleImmediately()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isCommitEnabled());
    }

    @Test
    public void shouldReturnFalseWhenCommitDisabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isSettleImmediately()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isCommitEnabled());
    }

    @Test
    public void shouldReturnTrueWhenVenmoEnabled() {
        when(payPalPluginConfigurationModel.getVenmoConfiguration().isEnable()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isVenmoEnabled());
    }

    @Test
    public void shouldReturnFalseWhenVenmoDisabled() {
        when(payPalPluginConfigurationModel.getVenmoConfiguration().isEnable()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isVenmoEnabled());
    }

    @Test
    public void shouldReturnTrueWhenPayLaterEnabledForNonUsCountries() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isPayLaterForNonUsCountries()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isPayLaterEnabledForNonUsCountries());
    }

    @Test
    public void shouldReturnFalseWhenPayLaterDisabledForNonUsCountries() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isPayLaterForNonUsCountries()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isPayLaterEnabledForNonUsCountries());
    }

    @Test
    public void shouldReturnFalseWhenReplenishmentNotAvailable() {
        assertFalse(unit.isReplenishmentAvailable());
    }

    @Test
    public void shouldReturnClientID() {
        when(configurationService.getConfiguration().getString(CLIENT_ID)).thenReturn(TEST_CLIENT_ID);

        assertEquals(TEST_CLIENT_ID, unit.getClientID());
    }

    @Test
    public void shouldReturnPayPalPartnerAttributionId() {
        when(configurationService.getConfiguration().getString(PAYPAL_PARTNER_ATTRIBUTION_ID)).thenReturn(TEST_PAY_PAL_PARTNER_ATTRIBUTION);

        assertEquals(TEST_PAY_PAL_PARTNER_ATTRIBUTION, unit.getPayPalPartnerAttributionId());
    }

    @Test
    public void shouldReturnPayPalExpireBetween() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().getExpireBetween()).thenReturn(2);

        assertEquals(2, unit.getPayPalExpireBetween());
    }

    @Test
    public void shouldReturnTrueWhenPayPalCreditCardIsExpireOnAdding() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().isExpireOnAdding()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isPayPalCreditCardOnAddingValidation());
    }

    @Test
    public void shouldReturnFalseWhenPayPalCreditCardIsNotExpireOnAdding() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().isExpireOnAdding()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isPayPalCreditCardOnAddingValidation());
    }

    @Test
    public void shouldReturnTrueWhenPayPalConnectAddPaymentMethodFlowEnabled() {
        when(payPalPluginConfigurationModel.getConnectWithPayPalConfiguration().isAddPaymentMethodFlow()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isPayPalConnectAddPaymentMethodFlow());
    }

    @Test
    public void shouldReturnFalseWhenPayPalConnectAddPaymentMethodFlowDisabled() {
        when(payPalPluginConfigurationModel.getConnectWithPayPalConfiguration().isAddPaymentMethodFlow()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isPayPalConnectAddPaymentMethodFlow());
    }

    @Test
    public void shouldReturnTrueWhenApplePayEnable() {
        when(payPalPluginConfigurationModel.getApplePayConfiguration().isEnable()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isApplePayEnable());
    }

    @Test
    public void shouldReturnFalseWhenApplePayDisabled() {
        when(payPalPluginConfigurationModel.getApplePayConfiguration().isEnable()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isApplePayEnable());
    }

    @Test
    public void shouldReturnTrueWhenL2L3DataEnabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isL2L3Data()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isL2L3DataEnabled());
    }

    @Test
    public void shouldReturnFalseWhenL2L3DataDisabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isL2L3Data()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isL2L3DataEnabled());
    }

    @Test
    public void shouldReturnTrueWhenApplePayOnExpressCheckoutEnable() {
        when(payPalPluginConfigurationModel.getApplePayConfiguration().isExpressCheckoutEnable()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isApplePayOnExpressCheckoutEnable());
    }

    @Test
    public void shouldReturnFalseWhenApplePayOnExpressCheckoutDisabled() {
        when(payPalPluginConfigurationModel.getApplePayConfiguration().isExpressCheckoutEnable()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isApplePayOnExpressCheckoutEnable());
    }

    @Test
    public void shouldReturnTrueWhenPayPalEnable() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isPayPalEnable()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isPayPalEnable());
    }

    @Test
    public void shouldReturnFalseWhenPayPalDisabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isPayPalEnable()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isPayPalEnable());
    }

    @Test
    public void shouldReturnTrueWhenPayPalIntentAuthorizeOrderFlowEnabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isSaveOrderFlow()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isSaveOrderFlow());
    }

    @Test
    public void shouldReturnFalseWhenPayPalIntentAuthorizeOrderFlowDisabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isSaveOrderFlow()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isSaveOrderFlow());
    }


    @Test
    public void shouldReturnTrueWhenPayPalVaultEnabled() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().isVaultFlow()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isPayPalHostedFieldsVaultEnabled());
    }

    @Test
    public void shouldReturnFalseWhenPayPalVaultDisabled() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().isVaultFlow()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isPayPalHostedFieldsVaultEnabled());
    }

    @Test
    public void shouldReturnPayPalVerifyCCOnMyAccount() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().getVerificationOnMyAccount()).thenReturn(ThreeDsVerificationOnMyAccountType.SCA_ALWAYS);

        assertEquals(ThreeDsVerificationOnMyAccountType.SCA_ALWAYS.getCode(), unit.getPayPalVerifyCCOnMyAccount());
    }

    @Test
    public void shouldReturnTrueWhenPayPalAdditionalSecurityEnabled() {
        when(payPalPluginConfigurationModel.getConnectWithPayPalConfiguration().isAdditionalSecurity()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isPayPalAdditionalSecurityEnabled());
    }

    @Test
    public void shouldReturnFalseWhenPayPalAdditionalSecurityDisabled() {
        when(payPalPluginConfigurationModel.getConnectWithPayPalConfiguration().isAdditionalSecurity()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isPayPalAdditionalSecurityEnabled());
    }

    @Test
    public void shouldReturnTrueWhenPayPalHostedFieldsEnabled() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().isEnable()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isPayPalHostedFieldsEnabled());
    }

    @Test
    public void shouldReturnFalseWhenPayPalHostedFieldsDisabled() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().isEnable()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isPayPalHostedFieldsEnabled());
    }

    @Test
    public void shouldReturnTrueWhenFraudNetEnabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isFraudNetIntegration()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isFraudNetEnabled());
    }

    @Test
    public void shouldReturnFalseWhenFraudNetDisabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isFraudNetIntegration()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isFraudNetEnabled());
    }

    @Test
    public void shouldReturnTrueWhenFraudNetSandboxEnabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isFraudNetSandbox()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isFraudNetSandboxEnabled());
    }

    @Test
    public void shouldReturnFalseWhenFraudNetSandboxDisabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isFraudNetSandbox()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isFraudNetSandboxEnabled());
    }

    @Test
    public void shouldReturnFraudNetIdWithAppropriatePage() {
        when(configurationService.getConfiguration().getString(PAYPAL_FRAUDNET_CART_ID)).thenReturn(TEST_FRAUD_NET_ID);

        assertEquals(TEST_FRAUD_NET_ID, unit.getFraudNetId(CART));
    }

    @Test
    public void shouldReturnSecretKey() {
        when(configurationService.getConfiguration().getString(SECRET_KEY)).thenReturn(TEST_SECRET_KEY);

        assertEquals(TEST_SECRET_KEY, unit.getSecretKey());
    }

    @Test
    public void shouldReturnEnvironmentType() {
        when(configurationService.getConfiguration().getString(PAYPAL_ENV_CONFIGURATION)).thenReturn(TEST_ENV_TYPE);

        assertEquals(TEST_ENV_TYPE, unit.getEnvironmentType());
    }

    @Test
    public void shouldReturnPayPalApiUrl() {
        when(configurationService.getConfiguration().getString(PAYPAL_API_URL)).thenReturn(TEST_API_URL);

        assertEquals(TEST_API_URL, unit.getPayPalApiUrl());
    }

    @Test
    public void shouldReturnPayPalSdkJsUrl() {
        when(configurationService.getConfiguration().getString(PAYPAL_SDK_JS_URL)).thenReturn(TEST_SDK_JS_URL);

        assertEquals(TEST_SDK_JS_URL, unit.getPayPalSdkJsUrl());
    }

    @Test
    public void shouldReturnCapturePayPalIntentWhenSettleImmediatelyEnabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isSettleImmediately()).thenReturn(Boolean.TRUE);

        assertEquals(PAYPAL_INTENT_CAPTURE, unit.getPayPalIntent());
    }

    @Test
    public void shouldReturnAuthorizePayPalIntentWhenSettleImmediatelyDisabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isSettleImmediately()).thenReturn(Boolean.FALSE);

        assertEquals(PAYPAL_INTENT_AUTHORIZE, unit.getPayPalIntent());
    }


    @Test
    public void shouldReturnCapturePayPalIntentByBaseStoreWhenSettleImmediatelyEnabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isSettleImmediately()).thenReturn(Boolean.TRUE);

        assertEquals(PAYPAL_INTENT_CAPTURE, unit.getPayPalIntent(baseStore));
    }

    @Test
    public void shouldReturnAuthorizePayPalIntentByBaseStoreWhenSettleImmediatelyDisabled() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isSettleImmediately()).thenReturn(Boolean.FALSE);

        assertEquals(PAYPAL_INTENT_AUTHORIZE, unit.getPayPalIntent(baseStore));
    }

    @Test
    public void shouldReturnTrueWhenConnectWithPayPalIsEnable() {
        when(payPalPluginConfigurationModel.getConnectWithPayPalConfiguration().isEnable()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isConnectWithPayPalIsEnable());
    }

    @Test
    public void shouldReturnFalseWhenConnectWithPayPalIsDisabled() {
        when(payPalPluginConfigurationModel.getConnectWithPayPalConfiguration().isEnable()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isConnectWithPayPalIsEnable());
    }

    @Test
    public void shouldReturnPayPal3DSVerificationType() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().getThreeDsVerificationOnCheckout()).thenReturn(ThreeDsVerificationType.ALWAYS);

        assertEquals(ThreeDsVerificationType.ALWAYS.getCode(), unit.getPayPal3DSVerificationType());
    }

    @Test
    public void shouldReturnNonDecimalCurrency() {
        when(configurationService.getConfiguration().getString(PAYPAL_NONDECIMAL_CURRENCY)).thenReturn(TEST_NON_DECIMAL_CURRENCY);

        assertEquals(TEST_NON_DECIMAL_CURRENCY, unit.getNonDecimalCurrency());
    }

    @Test
    public void shouldReturnPayPalConnectScript() {
        when(configurationService.getConfiguration().getString(PAYPAL_CONNECT_SCRIPT)).thenReturn(TEST_CONNECT_SCRIPT);

        assertEquals(TEST_CONNECT_SCRIPT, unit.getPayPalConnectScript());
    }

    @Test
    public void shouldReturnPayPalConnectScopes() {
        when(configurationService.getConfiguration().getString(PAYPAL_CONNECT_SCOPES)).thenReturn(TEST_CONNECT_SCOPES);

        assertEquals(TEST_CONNECT_SCOPES, unit.getPayPalConnectScopes());
    }

    @Test
    public void shouldReturnPayPalConnectResponseType() {
        when(configurationService.getConfiguration().getString(PAYPAL_CONNECT_RESPONSE_TYPE)).thenReturn(TEST_CONNECT_RESPONSE_TYPE);

        assertEquals(TEST_CONNECT_RESPONSE_TYPE, unit.getPayPalConnectResponseType());
    }

    @Test
    public void shouldReturnPayPalConnectReturnUrl() {
        when(configurationService.getConfiguration().getString(PAYPAL_CONNECT_RETURN_URL)).thenReturn(TEST_RETURN_URL);

        assertEquals(TEST_RETURN_URL, unit.getPayPalConnectReturnUrl());
    }

    @Test
    public void getPayPalConnectCheckoutReturnUrl() {
        when(configurationService.getConfiguration().getString(PAYPAL_CONNECT_CHECKOUT_RETURN_URL)).thenReturn(TEST_RETURN_URL);

        assertEquals(TEST_RETURN_URL, unit.getPayPalConnectCheckoutReturnUrl());
    }

    @Test
    public void shouldReturnTrueWhenEnableLoginViaPayPalToTheExistingUser() {
        when(payPalPluginConfigurationModel.getConnectWithPayPalConfiguration().isLinkUserAccount()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isEnableLoginViaPayPalToTheExistingUser());
    }

    @Test
    public void shouldReturnFalseWhenDisabledLoginViaPayPalToTheExistingUser() {
        when(payPalPluginConfigurationModel.getConnectWithPayPalConfiguration().isLinkUserAccount()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isEnableLoginViaPayPalToTheExistingUser());
    }

    @Test
    public void shouldReturnBuyerCountry() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().getBuyerCountry()).thenReturn(TEST_BUYER_COUNTRY);

        assertEquals(TEST_BUYER_COUNTRY, unit.getBuyerCountry());
    }

    @Test
    public void shouldReturnLocale() {
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().getLocale()).thenReturn(TEST_LOCALE);

        assertEquals(TEST_LOCALE, unit.getLocale());
    }

    @Test
    public void shouldReturnTrueWhenSaveOrderFlowAvailable() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isSaveOrderFlow()).thenReturn(Boolean.TRUE);
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isSettleImmediately()).thenReturn(Boolean.FALSE);

        assertTrue(unit.isSaveOrderFlow());
    }

    @Test
    public void shouldReturnFalseWhenSaveOrderFlowNotAvailable() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isSaveOrderFlow()).thenReturn(Boolean.TRUE);
        when(payPalPluginConfigurationModel.getPayPalGeneralConfiguration().isSettleImmediately()).thenReturn(Boolean.TRUE);

        assertFalse(unit.isSaveOrderFlow());
    }

    @Test
    public void shouldReturnPayPalPluginConfiguration() {
        assertEquals(payPalPluginConfigurationModel, unit.getPayPalPluginConfiguration());
    }

    @Test(expected = PayPalPluginConfigurationNotFound.class)
    public void shouldThrowPayPalPluginConfigurationNotFoundWhenPayPalPluginConfigurationNotExist() {
        when(baseStore.getPayPalPluginConfiguration()).thenReturn(null);

        unit.getPayPalPluginConfiguration();
    }

    @Test
    public void shouldReturnTrueWhenLocalPaymentsEnable() {
        when(payPalPluginConfigurationModel.getLocalPaymentsConfiguration().isEnable()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isLocalPaymentsEnable());
    }

    @Test
    public void shouldReturnFalseWhenLocalPaymentsDisabled() {
        when(payPalPluginConfigurationModel.getLocalPaymentsConfiguration().isEnable()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isLocalPaymentsEnable());
    }

    @Test
    public void shouldReturnTrueWhenThreeDsVerificationOnCheckoutEnable() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().getThreeDsVerificationOnCheckout()).thenReturn(ThreeDsVerificationType.ALWAYS);

        assertTrue(unit.isThreeDsVerificationOnCheckoutEnable());
    }

    @Test
    public void shouldReturnFalseWhenThreeDsVerificationOnCheckoutDisabled() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().getThreeDsVerificationOnCheckout()).thenReturn(ThreeDsVerificationType.DISABLE);

        assertFalse(unit.isThreeDsVerificationOnCheckoutEnable());
    }

    @Test
    public void shouldReturnTrueWhenVaultEnabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isVaultEnabled()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isPayPalVaultEnabled());
    }

    @Test
    public void shouldReturnFalseWhenVaultDisabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isVaultEnabled()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isPayPalVaultEnabled());
    }

    @Test
    public void shouldReturnTrueWhenChangePaymentButtonEnabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isChangePaymentButtonEnabled()).thenReturn(Boolean.TRUE);

        assertTrue(unit.isChangePaymentButtonEnabled());
    }

    @Test
    public void shouldReturnFalseWhenChangePaymentButtonDisabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isChangePaymentButtonEnabled()).thenReturn(Boolean.FALSE);

        assertFalse(unit.isChangePaymentButtonEnabled());
    }

    @Test
    public void shouldReturnSavedCreditCardsLimit() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().getSavedCreditCardsLimit()).thenReturn(SavedPaymentMethodsLimit.FIVE);

        assertEquals(SavedPaymentMethodsLimit.FIVE, unit.getSavedCreditCardsLimit());
    }

    @Test
    public void shouldReturnSavedPayPalAccountsLimit() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().getSavedPayPalAccountsLimit()).thenReturn(SavedPaymentMethodsLimit.ONE);

        assertEquals(SavedPaymentMethodsLimit.ONE, unit.getSavedPayPalAccountsLimit());
    }

    @Test
    public void shouldReturnTrueWhenThreeDsVerificationOnCheckoutAlwaysRequiredEnable() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().getThreeDsVerificationOnCheckout()).thenReturn(ThreeDsVerificationType.ALWAYS);

        assertTrue(unit.isThreeDsVerificationOnCheckoutAlwaysRequiredEnable());
    }

    @Test
    public void shouldReturnFalseWhenThreeDsVerificationOnCheckoutAlwaysRequiredDisabled() {
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration().getThreeDsVerificationOnCheckout()).thenReturn(ThreeDsVerificationType.DISABLE);

        assertFalse(unit.isThreeDsVerificationOnCheckoutAlwaysRequiredEnable());
    }

    @Test
    public void shouldReturnTrueWhenPayPalAndVaultAreEnabled() {
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isPayPalEnable()).thenReturn(true);
        when(payPalPluginConfigurationModel.getPayPalConfiguration().isVaultEnabled()).thenReturn(true);

        assertTrue(unit.isPayPalVaultFlowEnabled());
    }

}
